<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/sql" prefix="sql" %>
<%@taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib prefix="rmutils" tagdir="/WEB-INF/tags" %>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Projects</title>
    </head>



    <body>
        <h1>Version Compatibility List</h1>
        <p>
            The following is the list of compatible versions of CCS packages for Toolkit release cycle <rmutils:chooseReleaseCycle toolkitOnly="true"/>          
        </p>
        <p>
            The packages released in this release cycle are marked with a red star (<font style="color: red">*</font>). A complete list of the release packages
            can be found by going to the corresponding <a href="releaseNotes.jsp?relCycle=${displayRelCycle}">Release Notes</a> page.
        </p>

        <h3>External Pom Projects</h3>
        <p>
            The following are pure pom projects at the edge of the CCS Toolkit; they should be used by subsystem developers to pick up the desired version of the
            CCS libraries.
        </p>

        <rmutils:displayProjectsByType projectType="external-pom" relCycle="${displayRelCycle}"/>


        <h3>Toolkit</h3>
        <p>
            The CCS Toolkit contains the code for the CCS Buses, Messaging Layer, Core, Startup and Configuration Service. It provides the building blocks for any CCS Subsystem. The links in the Toolkit row provide aggregate reports over all the other packages.
        </p>

        <rmutils:displayProjectsByType showDescription="false" projectType="toolkit" relCycle="${displayRelCycle}"/>

        <h3>Components</h3>

        <rmutils:displayProjectsByType showDescription="false" projectType="component" relCycle="${displayRelCycle}"/>

        <h3>Utilities</h3>
        <p>
            These are the CCS utilities packages packages.
        </p>

        <rmutils:displayProjectsByType showDescription="false" projectType="utility" relCycle="${displayRelCycle}"/>

        <h3>Inner Pom Projects</h3>
        <p>
            CCS Pure pom project that define the inner CCS layers.
        </p>

        <rmutils:displayProjectsByType showDescription="true" projectType="internal-pom" relCycle="${displayRelCycle}"/>

        <h3>Test Related Projects</h3>

        <rmutils:displayProjectsByType showDescription="false" projectType="test" relCycle="${displayRelCycle}"/>





    </body>
</html>
