/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.release.management;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.lsst.ccs.release.management.JiraVersionManagement;
import org.srs.web.base.db.ConnectionManager;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReleaseManagementServlet
extends HttpServlet {
    static String[] subsystemModules = new String[]{"buses", "main", "gui"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String projectName = req.getParameter("projectName");
        String releaseVersion = req.getParameter("releaseVersion");
        String snapshotVersion = req.getParameter("snapshotVersion");
        String projectType = req.getParameter("projectType");
        String projectDescription = req.getParameter("projectDescription");
        String projectJiraProject = req.getParameter("projectJiraProject");
        String projectJiraPrefix = req.getParameter("projectJiraPrefix");
        if (projectName != null) {
            Connection conn = null;
            try {
                conn = ConnectionManager.getConnection((String)"jdbc/ccs");
                conn.setAutoCommit(true);
                String projectCheckQuery = "select * from ccs_Projects where name = ?";
                PreparedStatement projectCheckStat = conn.prepareStatement(projectCheckQuery);
                projectCheckStat.setString(1, projectName);
                ResultSet projectCheckResult = projectCheckStat.executeQuery();
                boolean projectExists = projectCheckResult.next();
                if (!projectExists) {
                    PreparedStatement insertProjectStat = conn.prepareStatement("insert into ccs_Projects (name) values (?)");
                    insertProjectStat.setString(1, projectName);
                    insertProjectStat.executeUpdate();
                    PreparedStatement insertProjectDisplay = conn.prepareStatement("insert into ccs_Project_Display (projectName, projectSiteLocation, projectOrder, links) values (?,?,?,?)");
                    int order = 100;
                    if (projectType.equals("subsystem")) {
                        insertProjectDisplay.setString(1, projectName);
                        insertProjectDisplay.setString(2, "subsystems");
                        insertProjectDisplay.setInt(3, order);
                        insertProjectDisplay.setString(4, "apidoc,sourcecode,testcode,dependencies,tests,graph");
                        insertProjectDisplay.executeUpdate();
                        for (String mod : subsystemModules) {
                            String moduleName = projectName + "-" + mod;
                            PreparedStatement createModule = conn.prepareStatement("insert into ccs_Project_Modules (moduleName,projectName) values (?,?)");
                            createModule.setString(1, moduleName);
                            createModule.setString(2, projectName);
                            createModule.executeUpdate();
                            insertProjectDisplay.setString(1, moduleName);
                            insertProjectDisplay.setString(2, moduleName);
                            insertProjectDisplay.setInt(3, ++order);
                            insertProjectDisplay.setString(4, "apidoc,sourcecode,testcode,dependencies,tests,jdepend,graph,findbugs,dist");
                            insertProjectDisplay.executeUpdate();
                        }
                    } else if (projectType.equals("driver")) {
                        insertProjectDisplay.setString(1, projectName);
                        insertProjectDisplay.setString(2, "drivers");
                        insertProjectDisplay.setInt(3, order);
                        insertProjectDisplay.setString(4, "apidoc,sourcecode,testcode,dependencies,tests,jdepend,graph,findbugs,dist");
                        insertProjectDisplay.executeUpdate();
                    }
                }
                resp.getWriter().print("Updating information for project " + projectName + "\n");
                resp.getWriter().print("\tDescription: " + ReleaseManagementServlet.emptyStringIfNull((String)projectDescription) + "\n");
                resp.getWriter().print("\tType: " + ReleaseManagementServlet.emptyStringIfNull((String)projectType) + "\n");
                resp.getWriter().print("\tJira Project: " + ReleaseManagementServlet.emptyStringIfNull((String)projectJiraProject) + "\n");
                resp.getWriter().print("\tJira Prefix: " + ReleaseManagementServlet.emptyStringIfNull((String)projectJiraPrefix) + "\n");
                PreparedStatement projectInfoUpdateStat = conn.prepareStatement("update ccs_Projects set description=?, jiraProject=?, jiraVersionPrefix=?, type=? where name=?");
                projectInfoUpdateStat.setString(1, ReleaseManagementServlet.emptyStringIfNull((String)projectDescription));
                projectInfoUpdateStat.setString(2, ReleaseManagementServlet.emptyStringIfNull((String)projectJiraProject));
                projectInfoUpdateStat.setString(3, ReleaseManagementServlet.emptyStringIfNull((String)projectJiraPrefix));
                projectInfoUpdateStat.setString(4, ReleaseManagementServlet.emptyStringIfNull((String)projectType));
                projectInfoUpdateStat.setString(5, projectName);
                projectInfoUpdateStat.executeUpdate();
                if (releaseVersion != null && !"".equals(releaseVersion)) {
                    PreparedStatement activeRelCycleStat = conn.prepareStatement("select * from ccs_Release_Cycle where released = 0 and active = 1");
                    ResultSet activeRelCycleResult = activeRelCycleStat.executeQuery();
                    String relCycle = null;
                    if (activeRelCycleResult.next()) {
                        relCycle = activeRelCycleResult.getString("name");
                    } else {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        relCycle = df.format(new Date());
                        try {
                            PreparedStatement createRelCycleStat = conn.prepareStatement("insert into ccs_Release_Cycle (name,date) values (?,(select current_date from dual))");
                            createRelCycleStat.setString(1, relCycle);
                            createRelCycleStat.executeUpdate();
                            resp.getWriter().print("\nCreated Release Cycle " + relCycle + "https://srs.slac.stanford.edu/releaseManagement/releaseCycles.jsp\n");
                        }
                        catch (Exception createRelCycleStat) {
                            // empty catch block
                        }
                    }
                    PreparedStatement addReleaseStat = conn.prepareStatement("insert into ccs_Project_Version (projectName,version,relCycle,created,isSnapshot) values (?,?,?,(select current_timestamp from dual),0)");
                    addReleaseStat.setString(1, projectName);
                    addReleaseStat.setString(2, releaseVersion);
                    addReleaseStat.setString(3, relCycle);
                    addReleaseStat.executeUpdate();
                    resp.getWriter().print("Added Release " + releaseVersion + " to project " + projectName + " https://srs.slac.stanford.edu/releaseManagement/projectVersions.jsp?projectName=" + projectName + "for Release Cycle " + relCycle + "https://srs.slac.stanford.edu/releaseManagement/releaseNotes.jsp?relCycle=" + relCycle + "\n");
                    PreparedStatement removeSnapshotStat = conn.prepareStatement("delete from ccs_Project_Version where projectName = ? and version = ?");
                    removeSnapshotStat.setString(1, projectName);
                    removeSnapshotStat.setString(2, releaseVersion + "-SNAPSHOT");
                    removeSnapshotStat.executeUpdate();
                    if (relCycle != null) {
                        PreparedStatement updateResCycleVersions = conn.prepareStatement("update ccs_Release_Cycle_Versions set version = ? where projectName = ? and relCycle = ? ");
                        updateResCycleVersions.setString(1, releaseVersion);
                        updateResCycleVersions.setString(2, projectName);
                        updateResCycleVersions.setString(3, relCycle);
                        updateResCycleVersions.executeUpdate();
                    }
                }
                if (snapshotVersion != null && !"".equals(snapshotVersion)) {
                    try {
                        PreparedStatement addSnapshotToProject = conn.prepareStatement("insert into ccs_Project_Version (projectName,version,created) values (?,?,(select current_timestamp from dual))");
                        addSnapshotToProject.setString(1, projectName);
                        addSnapshotToProject.setString(2, snapshotVersion);
                        addSnapshotToProject.executeUpdate();
                        resp.getWriter().print("Added Snapshot " + snapshotVersion + " to project " + projectName + "https://srs.slac.stanford.edu/releaseManagement/projectVersions.jsp?projectName=" + projectName + "\n");
                    }
                    catch (IOException | SQLException addSnapshotToProject) {
                        // empty catch block
                    }
                }
                if (projectJiraProject == null || "".equals(projectJiraProject)) return;
                String jiraRelVersion = releaseVersion;
                String jiraNextVersion = snapshotVersion;
                if (projectJiraPrefix != null && !"".equals(projectJiraPrefix)) {
                    if (jiraRelVersion != null && !"".equals(jiraRelVersion)) {
                        jiraRelVersion = projectJiraPrefix + "-" + jiraRelVersion;
                    }
                    if (jiraNextVersion != null && !"".equals(jiraNextVersion)) {
                        jiraNextVersion = projectJiraPrefix + "-" + jiraNextVersion;
                    }
                }
                try {
                    JiraVersionManagement.updateJiraVersions((String)projectJiraProject, (String)jiraRelVersion, (String)jiraNextVersion);
                    return;
                }
                catch (JSONException ex) {
                    resp.getWriter().print("Problem updating Jira projects\n");
                    resp.getWriter().print(ex.getMessage() + "\n");
                }
                return;
            }
            catch (Exception ex) {
                resp.getWriter().print(ex.getMessage());
                return;
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    resp.getWriter().print(ex.getMessage());
                }
            }
        }
        resp.getWriter().print("ReleaseManagementServlet: no projectName was provided.");
    }

    private static String emptyStringIfNull(String value) {
        return value == null ? "" : value;
    }
}

