/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.release.management;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lsst.ccs.release.management.JiraIssue;

/*
 * Exception performing whole class analysis ignored.
 */
public class JiraVersionManagement {
    private static String jiraIssuesRequestParameter = "fixVersion=\"{0}\"&project={1}";
    private static WebTarget jiraRestWebTarget = null;
    private static MultivaluedMap<String, Object> jiraHeaders = new MultivaluedHashMap();

    private static WebTarget getJiraRestWebTarget() {
        if (jiraRestWebTarget == null) {
            ClientBuilder.newBuilder();
            Client client = ClientBuilder.newClient((Configuration)new ClientConfig());
            jiraRestWebTarget = client.target("https://jira.slac.stanford.edu/rest/api/2/");
        }
        return jiraRestWebTarget;
    }

    public static List<JiraIssue> getJiraIssues(String jiraProject, String jiraVersion) throws IOException {
        ArrayList<JiraIssue> jiraIssues = new ArrayList<JiraIssue>();
        WebTarget search = JiraVersionManagement.getJiraRestWebTarget().path("search");
        Response r = search.queryParam("jql", new Object[]{MessageFormat.format(jiraIssuesRequestParameter, jiraVersion, jiraProject)}).request().headers(jiraHeaders).get();
        String sResult = (String)r.readEntity(String.class);
        try {
            JSONObject result = new JSONObject(sResult);
            JSONArray issues = (JSONArray)result.get("issues");
            for (int i = 0; i < issues.length(); ++i) {
                JSONObject issue = issues.getJSONObject(i);
                jiraIssues.add(new JiraIssue(issue));
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(JiraVersionManagement.class.getName()).log(Level.SEVERE, null, ex);
        }
        return jiraIssues;
    }

    private static String getNewJiraVersionPayload(String jiraVersionName, String projectId) {
        return "{\"name\": \"" + jiraVersionName + "\",\"archived\": false,\"released\": false,\"projectId\": \"" + projectId + "\" }";
    }

    private static String getReleaseJiraVersionPayload(String jiraVersionName, String projectId, String newJiraId) {
        return "{\"name\": \"" + jiraVersionName + "\",\"archived\": false,\"released\": true,\"projectId\": \"" + projectId + "\",\"moveUnfixedIssuesTo\": \"" + newJiraId + "\",\"userReleaseDate\": \"" + new SimpleDateFormat("dd/MMM/yy").format(new Date()) + "\"  }";
    }

    public static void updateJiraVersions(String jiraProject, String releasedJiraVersion, String snapshotJiraVersion) throws JSONException {
        if (jiraProject != null && !jiraProject.equals("")) {
            JSONObject releasedVersionJiraJson;
            WebTarget project = JiraVersionManagement.getJiraRestWebTarget().path("project/" + jiraProject);
            Response r = project.request().headers(jiraHeaders).get();
            String sResult = (String)r.readEntity(String.class);
            String projectId = null;
            JSONArray versions = null;
            try {
                JSONObject result = new JSONObject(sResult);
                projectId = result.getString("id");
                versions = (JSONArray)result.get("versions");
            }
            catch (JSONException ex) {
                Logger.getLogger(JiraVersionManagement.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (projectId == null) {
                throw new RuntimeException("Could not find ID for project " + jiraProject);
            }
            JSONObject snapshotVersionJiraJson = null;
            if (snapshotJiraVersion != null && !snapshotJiraVersion.equals("")) {
                snapshotJiraVersion = snapshotJiraVersion.replace("-SNAPSHOT", "");
                WebTarget newVersion = JiraVersionManagement.getJiraRestWebTarget().path("version");
                snapshotVersionJiraJson = JiraVersionManagement.getVersionJson((JSONArray)versions, (String)snapshotJiraVersion);
                if (snapshotVersionJiraJson == null) {
                    Response rNewVersion = (Response)newVersion.request().headers(jiraHeaders).accept(new String[]{"application/json"}).post(Entity.entity((Object)JiraVersionManagement.getNewJiraVersionPayload((String)snapshotJiraVersion, (String)projectId), (String)"application/json"), Response.class);
                    String newVersionResult = (String)rNewVersion.readEntity(String.class);
                    snapshotVersionJiraJson = new JSONObject(newVersionResult);
                }
            }
            if (releasedJiraVersion != null && !releasedJiraVersion.equals("") && (releasedVersionJiraJson = JiraVersionManagement.getVersionJson((JSONArray)versions, (String)releasedJiraVersion)) != null && !releasedVersionJiraJson.getString("released").equals("true")) {
                WebTarget oldVersion = JiraVersionManagement.getJiraRestWebTarget().path("version/" + releasedVersionJiraJson.getString("id"));
                Response response = oldVersion.request().headers(jiraHeaders).accept(new String[]{"application/json"}).put(Entity.json((Object)JiraVersionManagement.getReleaseJiraVersionPayload((String)releasedJiraVersion, (String)projectId, (String)snapshotVersionJiraJson.getString("id"))));
            }
        }
    }

    private static JSONObject getVersionJson(JSONArray versions, String versionName) throws JSONException {
        for (int i = 0; i < versions.length(); ++i) {
            JSONObject version = versions.getJSONObject(i);
            if (!versionName.equals(version.getString("name"))) continue;
            return version;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        List issues = JiraVersionManagement.getJiraIssues((String)"LSSTCCS", (String)"core-4.5.0");
        System.out.println("Issues for core 3.0.2");
        for (JiraIssue issue : issues) {
            System.out.println(issue.getKey() + " " + issue.getResolution());
        }
        JiraVersionManagement.updateJiraVersions((String)"LSSTCCS", (String)"core-3.0.2", (String)"core-3.1.0");
        issues = JiraVersionManagement.getJiraIssues((String)"LSSTCCS", (String)"core-3.1.0");
        System.out.println("Issues for core 3.1.0");
        for (JiraIssue issue : issues) {
            System.out.println(issue.getKey() + " " + issue.getResolution());
        }
    }

    static {
        jiraHeaders.add((Object)"Content-Type", (Object)"application/json");
        jiraHeaders.add((Object)"Authorization", (Object)"Bearer Mzc0NTg4MzcwOTMzOuv1pr+yDq2MeZL0o23LcPZ+tEXB");
    }
}

