
package org.lsst.ccs.release.management;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A class representing a Jira Issue.
 * 
 * @author The CCS LSST Team.
 */
public class JiraIssue {
    
    private String typeIconUrl, key, summary, priorityIconUrl, status, resolution = "Unresolved";
    
    public JiraIssue(JSONObject jsonObj) throws JSONException {
        
        key = jsonObj.getString("key");
        JSONObject fields = jsonObj.getJSONObject("fields");
        summary = fields.getString("summary");
        JSONObject type = fields.getJSONObject("issuetype");
        typeIconUrl = type.getString("iconUrl");
        try {
            JSONObject relObject = fields.getJSONObject("resolution");
            if ( relObject != null ) {
                resolution = relObject.getString("name");                
            }
        } catch (JSONException e) {};
        
        JSONObject priority = fields.getJSONObject("priority");
        priorityIconUrl = priority.getString("iconUrl");
        status = fields.getJSONObject("status").getString("name");
    }

    public String getTypeIconUrl() {
        return typeIconUrl;
    }

    public String getKey() {
        return key;
    }

    public String getSummary() {
        return summary;
    }

    public String getPriorityIconUrl() {
        return priorityIconUrl;
    }

    public String getStatus() {
        return status;
    }

    public String getResolution() {
        return resolution;
    }
    
}
