/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import jline.internal.Configuration;
import org.lsst.ccs.shell.Command;
import org.lsst.ccs.shell.CommandTable;
import org.lsst.ccs.shell.Input;
import org.lsst.ccs.shell.Output;
import org.lsst.ccs.shell.OutputConversionEngine;
import org.lsst.ccs.shell.Param;
import org.lsst.ccs.shell.ShellCommand;
import org.lsst.ccs.shell.ShellManageable;
import org.lsst.ccs.shell.TokenException;
import org.lsst.ccs.shell.util.Strings;

public class ConsoleIO
implements Input,
Output,
ShellManageable {
    ConsoleReader consoleReader;
    boolean enableFileHistory = false;
    private BufferedReader in;
    private PrintStream out;
    private PrintStream err;
    private int lastCommandOffset = 0;
    private static final String USER_PROMPT_SUFFIX = "> ";
    private static final String FILE_PROMPT_SUFFIX = "$ ";
    private InputState inputState = InputState.USER;
    private BufferedReader scriptReader = null;
    private PrintStream log = null;
    private int loopCounter = 0;

    public ConsoleIO() {
        try {
            this.consoleReader = new ConsoleReader(System.in, (OutputStream)System.out);
            String fileHistoryOutputName = System.getProperty("org.lsst.ccs.cliche.file.history", "");
            String history = this.enableFileHistory(fileHistoryOutputName);
            System.out.println(history);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.err = System.err;
    }

    @Override
    public String readCommand(List<String> path) {
        try {
            String prompt = Strings.joinStrings(path, false, '/');
            switch (this.inputState) {
                case USER: {
                    return this.readUsersCommand(prompt);
                }
                case SCRIPT: {
                    String command = this.readCommandFromScript(prompt);
                    if (command != null) {
                        return command;
                    }
                    this.closeScript();
                    return this.readUsersCommand(prompt);
                }
            }
            return this.readUsersCommand(prompt);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public void setCommandTable(CommandTable commandTable) {
        List<ShellCommand> commands = commandTable.getCommandTable();
        ArrayList<String> commandNames = new ArrayList<String>();
        for (ShellCommand s : commands) {
            commandNames.add(s.getName());
        }
        StringsCompleter completer = new StringsCompleter(commandNames);
        this.consoleReader.addCompleter((Completer)completer);
    }

    public void addCompleter(Completer completer) {
        this.consoleReader.addCompleter(completer);
    }

    private String readUsersCommand(String prompt) throws IOException {
        String completePrompt = String.valueOf(prompt) + USER_PROMPT_SUFFIX;
        this.consoleReader.setPrompt(completePrompt);
        this.lastCommandOffset = completePrompt.length();
        String command = "";
        try {
            command = this.consoleReader.readLine();
        }
        catch (Exception exception) {}
        if (this.consoleReader.getHistory() instanceof FileHistory) {
            ((FileHistory)this.consoleReader.getHistory()).flush();
        }
        if (this.log != null) {
            this.log.println(command);
        }
        return command;
    }

    private String readCommandFromScript(String prompt) throws IOException {
        String command = this.scriptReader.readLine();
        if (command != null) {
            String completePrompt = String.valueOf(prompt) + FILE_PROMPT_SUFFIX;
            this.print(completePrompt);
            this.lastCommandOffset = completePrompt.length();
        }
        return command;
    }

    private void closeScript() throws IOException {
        if (this.scriptReader != null) {
            this.scriptReader.close();
            this.scriptReader = null;
        }
        this.inputState = InputState.USER;
    }

    @Command(description="Reads commands from file")
    public void runScript(@Param(name="filename", description="Full file name of the script") String filename) throws FileNotFoundException {
        this.scriptReader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        this.inputState = InputState.SCRIPT;
    }

    @Override
    public void outputHeader(String text) {
        if (text != null) {
            this.println(text);
        }
    }

    @Override
    public void output(Object obj, OutputConversionEngine oce) {
        if (obj == null) {
            return;
        }
        if ((obj = oce.convertOutput(obj)).getClass().isArray()) {
            int length = Array.getLength(obj);
            int i = 0;
            while (i < length) {
                this.output(Array.get(obj, i), 0, oce);
                ++i;
            }
        } else if (obj instanceof Collection) {
            for (Object elem : (Collection)obj) {
                this.output(elem, 0, oce);
            }
        } else {
            this.output(obj, 0, oce);
        }
    }

    private void output(Object obj, int indent, OutputConversionEngine oce) {
        if (obj == null) {
            return;
        }
        if (obj != null) {
            obj = oce.convertOutput(obj);
        }
        int i = 0;
        while (i < indent) {
            this.print("\t");
            ++i;
        }
        if (obj == null) {
            this.println("(null)");
        } else if (obj.getClass().isPrimitive() || obj instanceof String) {
            this.println(obj);
        } else if (obj.getClass().isArray()) {
            this.println("Array");
            int length = Array.getLength(obj);
            int i2 = 0;
            while (i2 < length) {
                this.output(Array.get(obj, i2), indent + 1, oce);
                ++i2;
            }
        } else if (obj instanceof Collection) {
            this.println("Collection");
            for (Object elem : (Collection)obj) {
                this.output(elem, indent + 1, oce);
            }
        } else if (obj instanceof Throwable) {
            this.println(obj);
            ((Throwable)obj).printStackTrace(this.out);
        } else {
            this.println(obj);
        }
    }

    private void print(Object x) {
        try {
            this.consoleReader.print((CharSequence)x.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.log != null) {
            this.log.print(x);
        }
    }

    private void println(Object x) {
        try {
            this.consoleReader.print((CharSequence)x.toString());
            this.consoleReader.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.log != null) {
            this.log.println(x);
        }
    }

    private void printErr(Object x) {
        this.err.print(x);
        if (this.log != null) {
            this.log.print(x);
        }
    }

    private void printlnErr(Object x) {
        this.err.println(x);
        if (this.log != null) {
            this.log.println(x);
        }
    }

    @Override
    public void outputException(String input, TokenException error) {
        int errIndex = error.getToken().getIndex() + this.lastCommandOffset;
        while (errIndex-- > 0) {
            this.printErr("-");
        }
        int i = 0;
        while (i < error.getToken().getString().length()) {
            this.printErr("^");
            ++i;
        }
        this.printlnErr("");
        this.printlnErr(error);
    }

    @Override
    public void outputException(Throwable e) {
        this.printlnErr(e);
        if (e.getCause() != null) {
            this.printlnErr(e.getCause());
        }
    }

    private boolean isLoggingEnabled() {
        return this.log != null;
    }

    @Override
    public void cliEnterLoop() {
        if (this.isLoggingEnabled()) {
            ++this.loopCounter;
        }
    }

    @Override
    public void cliLeaveLoop() {
        if (this.isLoggingEnabled()) {
            --this.loopCounter;
        }
        if (this.loopCounter < 0) {
            this.disableLogging();
        }
    }

    @Command(description="Sets up logging, which duplicates all subsequent output in a file")
    public void enableLogging(@Param(name="fileName", description="Name of the logfile") String filename) throws FileNotFoundException {
        this.log = new PrintStream(filename);
        this.loopCounter = 0;
    }

    @Command(description="Turns off logging")
    public String disableLogging() {
        if (this.log != null) {
            this.log.close();
            this.log = null;
            return "Logging disabled";
        }
        return "Logging is already disabled";
    }

    @Command(description="Turn On File History")
    public String enableFileHistory(@Param(name="file-name", description="Path to the file to save the table to.") String filename) {
        if (!"".equals(filename)) {
            File out = null;
            try {
                out = new File(filename);
                if (out.getParent() == null) {
                    out = new File(Configuration.getUserHome(), filename);
                }
                this.consoleReader.setHistory((History)new FileHistory(out));
                this.enableFileHistory = true;
            }
            catch (IOException ioe) {
                return "Could not open file history " + filename + "\n" + ioe.getMessage();
            }
            return "Writing command history to file " + out.getAbsolutePath();
        }
        this.enableFileHistory = false;
        this.consoleReader.setHistory((History)new MemoryHistory());
        return "Using in memory history";
    }

    @Command(description="Turn Off File History")
    public String disableFileHistory() {
        return this.enableFileHistory("");
    }

    @Command(description="Displays current command history")
    public String history() {
        int histSize = this.consoleReader.getHistory().size();
        if (histSize == 0) {
            return "No commands are currently in the history";
        }
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < histSize) {
            output.append(" " + i + " " + this.consoleReader.getHistory().get(i) + "\n");
            ++i;
        }
        return output.toString();
    }

    private static enum InputState {
        USER,
        SCRIPT;

    }
}

