/*
 * This file is part of the Cliche project, licensed under MIT License.
 * See LICENSE.txt file in root folder of Cliche sources.
 */

package org.lsst.ccs.shell;



/**
 * Command table entry
 */
public abstract class ShellCommand {

    private String prefix;
    private String name;
    private String description;
    private String abbreviation;
    // MT: What is the header and how is it used?
    private String header;
    private ShellCommandParamSpec[] paramSpecs;
    private boolean isVarArgs = false;

    public ShellCommand(String prefix, String name) {
        this.prefix = prefix;
        this.name = name;
    }
    
    public boolean isVarArgs() {
        return isVarArgs;
    }

    public abstract Object invoke(Object[] parameters) throws CLIException;

    public boolean canBeDenotedBy(String commandName) {
        return commandName.equals(prefix + name) || commandName.equals(prefix + abbreviation);
    }

    public int getArity() {
        return paramSpecs.length;
    }

    public String getDescription() {
        return description;
    }

    public String getPrefix() {
        return prefix;
    }

    public String getName() {
        return name;
    }

    public String getAbbreviation() {
        return abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHeader(String header) {
        this.header = header;
    }



    public boolean startsWith(String prefix) {
        return (this.prefix + abbreviation).startsWith(prefix) ||
                (this.prefix + name).startsWith(prefix);
    }

    @Override
    public String toString() {
        return prefix + name + "\t" + (abbreviation != null ? prefix + abbreviation : "") + "\t" +
                paramSpecs.length + (isVarArgs() ? "+" : "") + "\t" + description;
    }

    public String getHeader() {
        return header;
    }

    public ShellCommandParamSpec[] getParamSpecs() {
        return paramSpecs;
    }
    
    public Class[] getParameterTypes() {
        Class[] types = new Class[paramSpecs.length];
        int count = 0;
        for( ShellCommandParamSpec spec: paramSpecs) {
            types[count++] = spec.getValueClass();
        }
        return types;
    }

    public void setParamSpecs(ShellCommandParamSpec[] paramSpecs) {
        this.paramSpecs = paramSpecs;
    }

}
