/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.web.rest.file.server.TestServer;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;
import org.lsst.ccs.web.rest.file.server.data.VersionInfo;
import org.lsst.ccs.web.rest.file.server.data.VersionInfoV2;

public class VersionedFileServerTest {
    private static TestServer testServer;

    @BeforeAll
    public static void setUpClass() throws URISyntaxException, IOException {
        testServer = new TestServer();
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        testServer.shutdown();
    }

    @BeforeEach
    public void setUp() throws URISyntaxException {
    }

    @AfterEach
    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicFileOperations() throws URISyntaxException, InterruptedException, ProtocolException, MalformedURLException, IOException {
        try (Client client = ClientBuilder.newClient();){
            RestFileInfo fileInfo = this.list(client);
            Assertions.assertEquals((int)0, (int)fileInfo.getChildren().size());
            String testFile = "test.file";
            String content = "Test content";
            this.upload("test.file", "Test content");
            RestFileInfo fileInfo2 = this.list(client);
            Assertions.assertEquals((int)1, (int)fileInfo2.getChildren().size());
            VersionInfo fileInfo4 = this.info(client, "test.file");
            Assertions.assertEquals((Object)"1", (Object)((VersionInfo.Version)fileInfo4.getVersions().get(0)).getName());
            Assertions.assertEquals((long)"Test content".length(), (long)((VersionInfo.Version)fileInfo4.getVersions().get(0)).getSize());
            VersionInfoV2 fileInfo5 = this.info2(client, "test.file");
            Assertions.assertEquals((Object)"1", (Object)((VersionInfoV2.Version)fileInfo5.getVersions().get(0)).getName());
            Assertions.assertEquals((long)"Test content".length(), (long)((VersionInfoV2.Version)fileInfo5.getVersions().get(0)).getSize());
            Assertions.assertFalse((boolean)((VersionInfoV2.Version)fileInfo5.getVersions().get(0)).isHidden());
            this.download("test.file", "Test content");
            this.delete(client, "test.file");
            RestFileInfo fileInfo3 = this.list(client);
            Assertions.assertEquals((int)0, (int)fileInfo3.getChildren().size());
        }
    }

    private void download(String testFile, String content) throws IOException {
        URI downloadURI = testServer.getServerURI().resolve("rest/version/download/" + testFile);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(downloadURI.toURL().openStream()));){
            String line = reader.readLine();
            Assertions.assertEquals((Object)content, (Object)line);
        }
    }

    private void upload(String testFile, String content) throws IOException, ProtocolException {
        URI uploadURI = testServer.getServerURI().resolve("rest/version/upload/" + testFile);
        HttpURLConnection connection = (HttpURLConnection)uploadURI.toURL().openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestMethod("POST");
        try (OutputStream out = connection.getOutputStream();){
            out.write(content.getBytes());
        }
        Assertions.assertEquals((int)200, (int)connection.getResponseCode());
    }

    private void delete(Client client, String file) {
        URI deleteURI = testServer.getServerURI().resolve("rest/version/deleteFile/" + file);
        Response response3 = client.target(deleteURI).request(new String[]{"application/json"}).delete();
        Assertions.assertEquals((int)200, (int)response3.getStatus());
    }

    private RestFileInfo list(Client client) {
        URI listURI = testServer.getServerURI().resolve("rest/list");
        Response response = client.target(listURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertNotNull((Object)response.getEntityTag());
        RestFileInfo fileInfo = (RestFileInfo)response.readEntity(RestFileInfo.class);
        return fileInfo;
    }

    private VersionInfo info(Client client, String file) {
        URI infoURI = testServer.getServerURI().resolve("rest/version/info/" + file);
        Response response = client.target(infoURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertNotNull((Object)response.getEntityTag());
        VersionInfo fileInfo = (VersionInfo)response.readEntity(VersionInfo.class);
        return fileInfo;
    }

    private VersionInfoV2 info2(Client client, String file) {
        Client client2 = ClientBuilder.newClient();
        client2.register((Object)new AddProtcolVersionRequestFilter());
        URI infoURI = testServer.getServerURI().resolve("rest/version/info/" + file);
        Response response = client2.target(infoURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertNotNull((Object)response.getEntityTag());
        VersionInfoV2 fileInfo = (VersionInfoV2)response.readEntity(VersionInfoV2.class);
        return fileInfo;
    }

    private static class AddProtcolVersionRequestFilter
    implements ClientRequestFilter {
        public static final String FILTER_HEADER_VALUE = "2";
        public static final String FILTER_HEADER_KEY = "x-protocol-version";

        private AddProtcolVersionRequestFilter() {
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            requestContext.getHeaders().add((Object)FILTER_HEADER_KEY, (Object)FILTER_HEADER_VALUE);
        }
    }
}

