/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.jvnet.hk2.annotations.Optional;
import org.lsst.ccs.web.rest.file.server.ETagHelper;
import org.lsst.ccs.web.rest.file.server.VersionedFile;
import org.lsst.ccs.web.rest.file.server.data.VersionInfoV2;
import org.lsst.ccs.web.rest.file.server.data.VersionOptions;
import org.lsst.ccs.web.rest.file.server.jwt.JWTTokenNeeded;

@Path(value="version")
@Produces(value={"application/json"})
public class VersionedFileServer {
    @Inject
    @Optional
    private java.nio.file.Path baseDir;

    @Context
    public void setServletContext(ServletContext context) throws IOException {
        String initParameter;
        if (context != null && (initParameter = context.getInitParameter("org.lsst.ccs.web.rest.file.server.baseDir")) != null) {
            this.baseDir = Paths.get(initParameter, new String[0]);
        }
        if (this.baseDir == null) {
            this.baseDir = Paths.get("/home/tonyj/ConfigTest/", new String[0]);
        }
    }

    @GET
    @Path(value="info/{filePath: .*}")
    public Response info(@PathParam(value="filePath") String filePath, @Context Request request, @HeaderParam(value="x-protocol-version") Integer protocolVersion) throws IOException {
        int[] versions;
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile cf = new VersionedFile(path);
        ArrayList<VersionInfoV2.Version> fileVersions = new ArrayList<VersionInfoV2.Version>();
        for (int version : versions = cf.getVersions()) {
            java.nio.file.Path child = cf.getPathForVersion(version);
            BasicFileAttributes fileAttributes = Files.getFileAttributeView(child, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            VersionInfoV2.Version info = new VersionInfoV2.Version(child, fileAttributes, version, cf.isHidden(version), cf.getComment(version));
            fileVersions.add(info);
        }
        VersionInfoV2 result = new VersionInfoV2(cf.getDefaultVersion(), cf.getLatestVersion(), fileVersions);
        Serializable finalResult = result.downgrade(protocolVersion);
        EntityTag eTag = new EntityTag(ETagHelper.computeEtag(finalResult));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder != null) {
            return builder.tag(eTag).build();
        }
        return Response.ok((Object)finalResult).tag(eTag).build();
    }

    @GET
    @Path(value="download/{filePath: .*}")
    @Produces(value={"application/octet-stream"})
    public Response file(@PathParam(value="filePath") String filePath, @QueryParam(value="version") String version, @Context Request request) throws IOException {
        int versionNumber;
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        java.nio.file.Path fileToReturn = vf.getPathForVersion(versionNumber = this.computeVersion(vf, version));
        Date lastModified = new Date(Files.getLastModifiedTime(fileToReturn, new LinkOption[0]).toMillis());
        Response.ResponseBuilder builder = request.evaluatePreconditions(lastModified);
        if (builder != null) {
            return builder.lastModified(lastModified).build();
        }
        StreamingOutput fileStream = output -> {
            byte[] data = Files.readAllBytes(fileToReturn);
            output.write(data);
            output.flush();
        };
        return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + path.getFileName())).header("version", (Object)versionNumber).lastModified(lastModified).build();
    }

    private int computeVersion(VersionedFile vf, String version) throws IOException, NumberFormatException {
        return this.computeVersion(vf, version, "default");
    }

    private int computeVersion(VersionedFile vf, String version, String defaultVersion) throws IOException, NumberFormatException {
        if (version == null || version.isEmpty()) {
            version = defaultVersion;
        }
        return switch (version) {
            case "default" -> vf.getDefaultVersion();
            case "latest" -> vf.getLatestVersion();
            default -> Integer.parseInt(version);
        };
    }

    @GET
    @Path(value="diff/{filePath: .*}")
    @Produces(value={"application/octet-stream"})
    public Response diff(@PathParam(value="filePath") String filePath, @QueryParam(value="v1") String v1, @QueryParam(value="v2") String v2, @Context Request request) throws IOException, DiffException {
        int iv1;
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        int iv2 = this.computeVersion(vf, v2, String.valueOf((iv1 = this.computeVersion(vf, v1, "latest")) - 1));
        if (iv2 < 1) {
            throw new IOException("No previous version");
        }
        java.nio.file.Path file1 = vf.getPathForVersion(iv1);
        java.nio.file.Path file2 = vf.getPathForVersion(iv2);
        List<String> lines1 = Files.readAllLines(file1);
        List<String> lines2 = Files.readAllLines(file2);
        Patch diff = DiffUtils.diff(lines2, lines1);
        List diffList = UnifiedDiffUtils.generateUnifiedDiff((String)(vf.getFileName() + ";" + iv2), (String)(vf.getFileName() + ";" + iv1), lines2, (Patch)diff, (int)2);
        EntityTag eTag = new EntityTag(ETagHelper.computeEtag((Serializable)((Object)diffList)));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder != null) {
            return builder.tag(eTag).build();
        }
        StreamingOutput fileStream = output -> {
            for (String dLines : diffList) {
                output.write(dLines.getBytes());
                output.write(10);
                output.flush();
            }
        };
        return Response.ok((Object)fileStream, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + path.getFileName())).tag(eTag).build();
    }

    @PUT
    @Path(value="set/{filePath: .*}")
    @JWTTokenNeeded
    @Consumes(value={"application/json"})
    public Object set(@PathParam(value="filePath") String filePath, int defaultVersion, @Context Request request, @HeaderParam(value="x-protocol-version") Integer protocolVersion) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        vf.setDefaultVersion(defaultVersion);
        return this.info(filePath, request, protocolVersion);
    }

    @PUT
    @Path(value="setOptions/{filePath: .*}")
    @JWTTokenNeeded
    @Consumes(value={"application/json"})
    public Object setOptions(@PathParam(value="filePath") String filePath, VersionOptions options, @Context Request request, @HeaderParam(value="x-protocol-version") Integer protocolVersion) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        int version = options.getVersion();
        if (options.getHidden() != null) {
            vf.setHidden(version, options.getHidden());
        }
        if (options.getComment() != null) {
            vf.setComment(version, options.getComment());
        }
        if (options.getMakeDefault() != null && options.getMakeDefault().booleanValue()) {
            vf.setDefaultVersion(version);
        }
        return this.info(filePath, request, protocolVersion);
    }

    @POST
    @Path(value="upload/{filePath: .*}")
    @JWTTokenNeeded
    @Consumes(value={"application/octet-stream"})
    public Object upload(@PathParam(value="filePath") String filePath, byte[] content) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        if (VersionedFile.isVersionedFile(path)) {
            VersionedFile vf = new VersionedFile(path);
            int newVersion = vf.addVersion(content, true);
            return Collections.singletonMap("version", newVersion);
        }
        VersionedFile vf = VersionedFile.create(path, content);
        return Collections.singletonMap("version", vf.getLatestVersion());
    }

    @DELETE
    @JWTTokenNeeded
    @Path(value="deleteFile/{filePath: .*}")
    public Response deleteFile(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        VersionedFile vf = new VersionedFile(path);
        vf.delete();
        return Response.ok().build();
    }
}

