/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.jvnet.hk2.annotations.Optional;
import org.lsst.ccs.web.rest.file.server.ETagHelper;
import org.lsst.ccs.web.rest.file.server.VersionedFile;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;

@Path(value="/")
@Produces(value={"application/json"})
public class FileServer {
    @Inject
    @Optional
    private java.nio.file.Path baseDir;

    @Context
    public void setServletContext(ServletContext context) throws IOException {
        String initParameter;
        if (context != null && (initParameter = context.getInitParameter("org.lsst.ccs.web.rest.file.server.baseDir")) != null) {
            this.baseDir = Paths.get(initParameter, new String[0]);
        }
        if (this.baseDir == null) {
            this.baseDir = Paths.get("/home/tonyj/ConfigTest/", new String[0]);
        }
    }

    @GET
    @Path(value="list")
    public Response list(@Context Request request) throws IOException {
        return this.list("", request);
    }

    @GET
    @Path(value="list/{filePath: .*}")
    public Response list(@PathParam(value="filePath") String filePath, @Context Request request) throws IOException {
        RestFileInfo fileProperties;
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        boolean isDirectory = Files.isDirectory(file, new LinkOption[0]);
        if (isDirectory) {
            List listFiles;
            try (Stream<java.nio.file.Path> list = Files.list(file);){
                listFiles = list.collect(Collectors.toList());
            }
            ArrayList<RestFileInfo> children = new ArrayList<RestFileInfo>();
            for (java.nio.file.Path child : listFiles) {
                BasicFileAttributes childAttributes = Files.getFileAttributeView(child, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
                boolean isVersioned = VersionedFile.isVersionedFile(child);
                if (isVersioned) {
                    VersionedFile vf = new VersionedFile(child);
                    childAttributes = Files.getFileAttributeView(vf.getLatest(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
                }
                RestFileInfo childProperties = new RestFileInfo(child, childAttributes, isVersioned);
                children.add(childProperties);
            }
            children.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
            fileProperties = this.getFileAtrributes(file, filePath, children);
        } else {
            fileProperties = this.getFileAtrributes(file, filePath, null);
        }
        EntityTag eTag = new EntityTag(ETagHelper.computeEtag((Serializable)fileProperties));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder != null) {
            return builder.tag(eTag).build();
        }
        return Response.ok((Object)fileProperties).tag(eTag).build();
    }

    @GET
    @Path(value="info/{filePath: .*}")
    public Response info(@PathParam(value="filePath") String filePath, @Context Request request) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        RestFileInfo fileAtrributes = this.getFileAtrributes(file, filePath, null);
        EntityTag eTag = new EntityTag(ETagHelper.computeEtag((Serializable)fileAtrributes));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder != null) {
            return builder.tag(eTag).build();
        }
        return Response.ok((Object)fileAtrributes).tag(eTag).build();
    }

    private RestFileInfo getFileAtrributes(java.nio.file.Path file, String filePath, List<RestFileInfo> children) throws IOException, NoSuchFileException {
        BasicFileAttributes fileAttributes = Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        if (fileAttributes == null) {
            throw new NoSuchFileException(filePath);
        }
        return new RestFileInfo(file, fileAttributes, VersionedFile.isVersionedFile(file), children);
    }

    @GET
    @Path(value="download/{filePath: .*}")
    @Produces(value={"application/octet-stream"})
    public Response file(@PathParam(value="filePath") String filePath, @Context Request request) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        if (Files.isReadable(file)) {
            Date lastModified = new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
            Response.ResponseBuilder builder = request.evaluatePreconditions(lastModified);
            if (builder != null) {
                return builder.lastModified(lastModified).build();
            }
            StreamingOutput fileStream = output -> {
                byte[] data = Files.readAllBytes(file);
                output.write(data);
                output.flush();
            };
            return Response.ok((Object)fileStream, (String)"application/octet-stream").lastModified(lastModified).header("content-disposition", (Object)("attachment; filename = " + file.getFileName())).build();
        }
        return Response.status((int)404, (String)("File not readable: " + file)).build();
    }

    @POST
    @Path(value="createDirectory/{filePath: .*}")
    public Response createDirectory(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        Files.createDirectory(file, new FileAttribute[0]);
        return Response.ok().build();
    }

    @POST
    @Path(value="createFile/{filePath: .*}")
    public Response createFile(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        Files.createFile(file, new FileAttribute[0]);
        return Response.ok().build();
    }

    @POST
    @Path(value="move/{filePath: .*}")
    public Response move(@PathParam(value="filePath") String source, @QueryParam(value="target") String target) throws IOException {
        java.nio.file.Path sourcePath = this.baseDir.resolve(source);
        java.nio.file.Path targetPath = this.baseDir.resolve(target);
        Files.move(sourcePath, targetPath, StandardCopyOption.ATOMIC_MOVE);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="deleteFile/{filePath: .*}")
    public Response deleteFile(@PathParam(value="filePath") String filePath) throws IOException {
        java.nio.file.Path file = this.baseDir.resolve(filePath);
        Files.delete(file);
        return Response.ok().build();
    }

    @POST
    @Path(value="upload/{filePath: .*}")
    @Consumes(value={"application/octet-stream"})
    public Response upload(@PathParam(value="filePath") String filePath, @QueryParam(value="openOption") List<String> openOptions, byte[] content) throws IOException {
        OpenOption[] soo = openOptions == null || openOptions.isEmpty() ? new StandardOpenOption[]{StandardOpenOption.CREATE_NEW} : (StandardOpenOption[])openOptions.stream().map(s -> StandardOpenOption.valueOf(s)).toArray(StandardOpenOption[]::new);
        java.nio.file.Path path = this.baseDir.resolve(filePath);
        try (OutputStream out = Files.newOutputStream(path, soo);){
            out.write(content);
        }
        return Response.ok().build();
    }
}

