/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;

public class VersionedFile {
    private static final Set<PosixFilePermission> READ_ONLY = PosixFilePermissions.fromString("r--r--r--");
    private static final String LATEST = "latest";
    private static final String DEFAULT = "default";
    private static final String USER_VERSIONED_FILE = "user.isVersionedFile";
    private final Path path;

    VersionedFile(Path path) throws IOException {
        this.path = path;
        if (!VersionedFile.isVersionedFile(path)) {
            throw new IOException("Not a versioned file: " + path);
        }
    }

    static boolean isVersionedFile(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        UserDefinedFileAttributeView view = Files.getFileAttributeView(path, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (!view.list().contains(USER_VERSIONED_FILE)) {
            return false;
        }
        return Files.isSymbolicLink(path.resolve(LATEST)) && Files.isSymbolicLink(path.resolve(DEFAULT));
    }

    int[] getVersions() throws IOException {
        return Files.list(this.path).filter(p -> !Files.isSymbolicLink(p)).mapToInt(p -> Integer.parseInt(p.getFileName().toString())).sorted().toArray();
    }

    int getLatestVersion() throws IOException {
        return Integer.parseInt(this.path.resolve(LATEST).toRealPath(new LinkOption[0]).getFileName().toString());
    }

    int getDefaultVersion() throws IOException {
        return Integer.parseInt(this.path.resolve(DEFAULT).toRealPath(new LinkOption[0]).getFileName().toString());
    }

    void setDefaultVersion(int version) throws IOException {
        Path targetPath = this.path.resolve(String.valueOf(version));
        if (version < 1 || !Files.exists(targetPath, new LinkOption[0])) {
            throw new IOException("Invalid version " + version);
        }
        Files.deleteIfExists(this.path.resolve(DEFAULT));
        Files.createSymbolicLink(this.path.resolve(DEFAULT), this.path.relativize(targetPath), new FileAttribute[0]);
    }

    Path getPathForVersion(int version) throws IOException {
        Path targetPath = this.path.resolve(String.valueOf(version));
        if (!Files.exists(this.path, new LinkOption[0])) {
            throw new IOException("Invalid version " + version);
        }
        return targetPath;
    }

    Path getDefault() {
        return this.path.resolve(DEFAULT);
    }

    Path getLatest() {
        return this.path.resolve(LATEST);
    }

    int addVersion(byte[] content, boolean onlyIfChanged) throws IOException {
        byte[] previousData;
        int version = this.getLatestVersion() + 1;
        if (version > 1 && onlyIfChanged && Arrays.equals(previousData = Files.readAllBytes(this.getLatest()), content)) {
            return this.getLatestVersion();
        }
        Path file = this.path.resolve(String.valueOf(version));
        Files.write(file, content, new OpenOption[0]);
        Files.setPosixFilePermissions(file, READ_ONLY);
        Files.deleteIfExists(this.path.resolve(LATEST));
        Files.createSymbolicLink(this.path.resolve(LATEST), this.path.relativize(file), new FileAttribute[0]);
        return version;
    }

    static VersionedFile create(Path path, byte[] content) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            throw new IOException("File already exists: " + path);
        }
        Path dir = Files.createDirectory(path, new FileAttribute[0]);
        UserDefinedFileAttributeView view = Files.getFileAttributeView(dir, UserDefinedFileAttributeView.class, new LinkOption[0]);
        view.write(USER_VERSIONED_FILE, Charset.defaultCharset().encode("true"));
        Path file = dir.resolve("1");
        Files.write(file, content, new OpenOption[0]);
        Files.setPosixFilePermissions(file, READ_ONLY);
        Files.createSymbolicLink(dir.resolve(LATEST), dir.relativize(file), new FileAttribute[0]);
        Files.createSymbolicLink(dir.resolve(DEFAULT), dir.relativize(file), new FileAttribute[0]);
        return new VersionedFile(dir);
    }

    static VersionedFile convert(Path unversionedFile) throws IOException {
        if (!Files.exists(unversionedFile, new LinkOption[0])) {
            throw new NoSuchFileException("File not found " + unversionedFile);
        }
        if (VersionedFile.isVersionedFile(unversionedFile)) {
            throw new IOException("File is already versioned: " + unversionedFile);
        }
        Path tempName = unversionedFile.resolveSibling(unversionedFile.getFileName() + "$$TMP$$");
        Path dir = Files.createDirectory(tempName, new FileAttribute[0]);
        UserDefinedFileAttributeView view = Files.getFileAttributeView(dir, UserDefinedFileAttributeView.class, new LinkOption[0]);
        view.write(USER_VERSIONED_FILE, Charset.defaultCharset().encode("true"));
        Path newFileName = tempName.resolve("1");
        Files.move(unversionedFile, newFileName, new CopyOption[0]);
        Files.setPosixFilePermissions(newFileName, READ_ONLY);
        Files.createSymbolicLink(dir.resolve(LATEST), dir.relativize(newFileName), new FileAttribute[0]);
        Files.createSymbolicLink(dir.resolve(DEFAULT), dir.relativize(newFileName), new FileAttribute[0]);
        Files.move(dir, unversionedFile, new CopyOption[0]);
        return new VersionedFile(unversionedFile);
    }

    String getFileName() {
        return this.path.getFileName().toString();
    }

    void delete() throws IOException {
        Files.walk(this.path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }
}

