/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.web.rest.file.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.web.rest.file.server.TestServer;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;

public class FileServerTest {
    private static TestServer testServer;

    public static URI getURI() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @BeforeAll
    public static void setUpClass() throws URISyntaxException, IOException {
        testServer = new TestServer();
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        testServer.shutdown();
    }

    @BeforeEach
    public void setUp() throws URISyntaxException {
    }

    @AfterEach
    public void tearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicFileOperations() throws URISyntaxException, InterruptedException, ProtocolException, MalformedURLException, IOException {
        try (Client client = ClientBuilder.newClient();){
            RestFileInfo fileInfo = this.list(client);
            Assertions.assertEquals((int)0, (int)fileInfo.getChildren().size());
            String testFile = "test.file";
            String content = "Test content";
            this.upload("test.file", "Test content");
            RestFileInfo fileInfo2 = this.list(client);
            Assertions.assertEquals((int)1, (int)fileInfo2.getChildren().size());
            RestFileInfo fileInfo4 = this.info(client, "test.file");
            Assertions.assertNull((Object)fileInfo4.getChildren());
            Assertions.assertEquals((Object)"test.file", (Object)fileInfo4.getName());
            Assertions.assertEquals((long)"Test content".length(), (long)fileInfo4.getSize());
            this.download("test.file", "Test content");
            this.delete(client, "test.file");
            RestFileInfo fileInfo3 = this.list(client);
            Assertions.assertEquals((int)0, (int)fileInfo3.getChildren().size());
        }
    }

    private void download(String testFile, String content) throws IOException {
        URI downloadURI = testServer.getServerURI().resolve("rest/download/" + testFile);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(downloadURI.toURL().openStream()));){
            String line = reader.readLine();
            Assertions.assertEquals((Object)content, (Object)line);
        }
    }

    private void upload(String testFile, String content) throws IOException, ProtocolException {
        URI uploadURI = testServer.getServerURI().resolve("rest/upload/" + testFile);
        HttpURLConnection connection = (HttpURLConnection)uploadURI.toURL().openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/octet-stream");
        connection.setRequestMethod("POST");
        try (OutputStream out = connection.getOutputStream();){
            out.write(content.getBytes());
        }
        Assertions.assertEquals((int)200, (int)connection.getResponseCode());
    }

    private void delete(Client client, String file) {
        URI deleteURI = testServer.getServerURI().resolve("rest/deleteFile/" + file);
        Response response3 = client.target(deleteURI).request(new String[]{"application/json"}).delete();
        Assertions.assertEquals((int)200, (int)response3.getStatus());
    }

    private RestFileInfo list(Client client) {
        URI listURI = testServer.getServerURI().resolve("rest/list");
        Response response = client.target(listURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertNotNull((Object)response.getEntityTag());
        RestFileInfo fileInfo = (RestFileInfo)response.readEntity(RestFileInfo.class);
        return fileInfo;
    }

    private RestFileInfo info(Client client, String file) {
        URI infoURI = testServer.getServerURI().resolve("rest/info/" + file);
        Response response = client.target(infoURI).request(new String[]{"application/json"}).get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertNotNull((Object)response.getEntityTag());
        RestFileInfo fileInfo = (RestFileInfo)response.readEntity(RestFileInfo.class);
        return fileInfo;
    }
}

