/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;
import org.lsst.ccs.rest.file.server.client.implementation.Cache;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;
import org.lsst.ccs.rest.file.server.client.implementation.RestPath;
import org.lsst.ccs.web.rest.file.server.TestServer;

public class VersionedFileTest {
    @Test
    public void fileWithVersionTest() throws IOException {
        RestPath path = new RestPath(null, "/file(7).txt");
        Assert.assertTrue((boolean)path.isVersionedFile());
        Assert.assertEquals((Object)"7", (Object)path.getVersion());
        Assert.assertEquals((Object)"file.txt", (Object)path.getRestPath());
        path = new RestPath(null, "/anotherFile.txt(d)");
        Assert.assertTrue((boolean)path.isVersionedFile());
        Assert.assertEquals((Object)"default", (Object)path.getVersion());
        Assert.assertEquals((Object)"anotherFile.txt", (Object)path.getRestPath());
    }

    @Test
    public void cacheOfflineTest() throws URISyntaxException, IOException, InterruptedException {
        this.cacheTest(9994, RestFileSystemOptions.CacheFallback.OFFLINE);
    }

    @Test
    public void cacheWhenPossibleTest() throws URISyntaxException, IOException, InterruptedException {
        this.cacheTest(9995, RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE);
    }

    public void cacheTest(int port, RestFileSystemOptions.CacheFallback cacheMode) throws URISyntaxException, IOException, InterruptedException {
        TestServer testServer = new TestServer(port);
        URI restRootURI = UriBuilder.fromUri((URI)testServer.getServerURI()).scheme("ccs").build(new Object[0]);
        Path tempDir = Files.createTempDirectory("rfs", new FileAttribute[0]);
        Map env = RestFileSystemOptions.builder().cacheLocation(tempDir).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).set(cacheMode).build();
        String content = "Some Content";
        String fileName = "testVersion.txt";
        try (FileSystem restfs = FileSystems.newFileSystem(restRootURI, env);){
            Path pathInRestServer = restfs.getPath("testVersion.txt", new String[0]);
            Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
            VersionOpenOption voo = VersionOpenOption.of((int)1);
            try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[]{voo});){
                writer.append("Some Content");
            }
            Assertions.assertTrue((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
            RestFileSystem client = (RestFileSystem)restfs;
            Cache cache = client.getCache();
            URI tmpFileUri = client.getURI("rest/version/download/testVersion.txt?version=default");
            URI fileUri = new URI(tmpFileUri.toString().replace("ccs:", "http:"));
            this.listAndRead(pathInRestServer, "Some Content", 1);
            Cache.CacheEntry e = cache.getEntry(fileUri);
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((int)0, (int)e.getUpdateCount());
            this.listAndRead(pathInRestServer, "Some Content", 1);
            Assertions.assertEquals((int)(cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? 0 : 1), (int)e.getUpdateCount());
            Thread.sleep(1000L);
            voo = VersionOpenOption.of((int)2);
            try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[]{voo, VersionOpenOption.DEFAULT});){
                writer.append("Some Content").append("Some Content");
            }
            Path versionedPathInRestServer = restfs.getPath("testVersion.txt(2)", new String[0]);
            this.listAndRead(versionedPathInRestServer, "Some ContentSome Content", 1);
            VersionedFileAttributes attributes = Files.readAttributes(versionedPathInRestServer, VersionedFileAttributes.class, new LinkOption[0]);
            Assert.assertEquals((long)1L, (long)attributes.getDefaultVersion());
            Assert.assertEquals((long)2L, (long)attributes.getLatestVersion());
            ((RestFileSystem)restfs).getClient().getVersionedAttributeView((RestPath)restfs.getPath("testVersion.txt", new String[0]), null).setDefaultVersion(2);
            versionedPathInRestServer = restfs.getPath("testVersion.txt(d)", new String[0]);
            attributes = Files.readAttributes(versionedPathInRestServer, VersionedFileAttributes.class, new LinkOption[0]);
            Assert.assertEquals((long)2L, (long)attributes.getDefaultVersion());
            Assert.assertEquals((long)2L, (long)attributes.getLatestVersion());
            this.listAndRead(versionedPathInRestServer, cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? "Some Content" : "Some ContentSome Content", 1, "Some ContentSome Content".length());
        }
        testServer.shutdown();
    }

    private void listAndRead(Path path, String content, int expectedListSize) throws IOException {
        this.listAndRead(path, content, expectedListSize, content.length());
    }

    private void listAndRead(Path path, String content, int expectedListSize, long expectedSize) throws IOException {
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Path parent = path.getParent();
        Assertions.assertTrue((boolean)Files.isDirectory(parent, new LinkOption[0]));
        List files = Files.list(parent).collect(Collectors.toList());
        Assertions.assertEquals((int)expectedListSize, (int)files.size());
        RestPath restPath = (RestPath)path;
        Path p = path;
        if (restPath.isVersionedFile()) {
            p = new RestPath((RestFileSystem)path.getFileSystem(), ((RestPath)path).getRestPath());
        }
        Assertions.assertTrue((boolean)Files.isSameFile(p, (Path)files.get(0)));
        List lines = Files.lines(path).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)content, lines.get(0));
        Assertions.assertEquals((long)expectedSize, (long)Files.size(path));
        BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertEquals((long)expectedSize, (long)attributes.size());
        Assertions.assertEquals((Object)"text/plain", (Object)Files.probeContentType(p));
    }
}

