/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.LinkedHashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystemOptionsHelper;

public class DefaultEnvTest {
    @Test
    public void defaultEnvTest() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        LinkedHashMap<String, Object> env = new LinkedHashMap<String, Object>();
        env.put("UseSSL", RestFileSystemOptions.SSLOptions.AUTO);
        env.put("CacheFallback", RestFileSystemOptions.CacheFallback.OFFLINE);
        env.put("CacheFallbackLocation", true);
        env.put("CacheLocation", new File("/tmp"));
        String json = objectMapper.writeValueAsString(env);
        System.out.println(json);
        System.setProperty("org.lsst.ccs.rest.file.client.defaultEnvironment", json);
        RestFileSystemOptionsHelper restFileSystemOptionsHelper = new RestFileSystemOptionsHelper(null);
        Assertions.assertEquals((Object)RestFileSystemOptions.SSLOptions.AUTO, (Object)restFileSystemOptionsHelper.isUseSSL());
        Assertions.assertEquals((Object)RestFileSystemOptions.CacheFallback.OFFLINE, (Object)restFileSystemOptionsHelper.getCacheFallback());
        Assertions.assertTrue((boolean)restFileSystemOptionsHelper.allowAlternateCacheLoction());
        Assertions.assertEquals((Object)"/tmp", (Object)restFileSystemOptionsHelper.getDiskCacheLocation().toAbsolutePath().toString());
    }
}

