/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;
import org.lsst.ccs.rest.file.server.client.implementation.Cache;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;
import org.lsst.ccs.web.rest.file.server.TestServer;

public class CachingTest {
    @Test
    public void cacheTest() throws URISyntaxException, IOException, InterruptedException {
        this.cacheTest(9997, RestFileSystemOptions.CacheFallback.OFFLINE);
    }

    @Test
    public void cacheTestWhenPossible() throws URISyntaxException, IOException, InterruptedException {
        this.cacheTest(9996, RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE);
    }

    public void cacheTest(int port, RestFileSystemOptions.CacheFallback cacheMode) throws URISyntaxException, IOException, InterruptedException {
        TestServer testServer = new TestServer(port);
        URI restRootURI = UriBuilder.fromUri((URI)testServer.getServerURI()).scheme("ccs").build(new Object[0]);
        Path tempDir = Files.createTempDirectory("rfs", new FileAttribute[0]);
        Map env = RestFileSystemOptions.builder().cacheLocation(tempDir).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).set(cacheMode).build();
        String content = "I wlll be cached!";
        String fileName = "testCache.txt";
        try (FileSystem restfs = FileSystems.newFileSystem(restRootURI, env);){
            Path pathInRestServer = restfs.getPath("testCache.txt", new String[0]);
            Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
            try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[0]);){
                writer.append("I wlll be cached!");
            }
            RestFileSystem client = (RestFileSystem)restfs;
            Cache cache = client.getCache();
            URI tmpFileUri = client.getURI("rest/download/testCache.txt");
            URI fileUri = new URI(tmpFileUri.toString().replace("ccs:", "http:"));
            this.listAndRead(pathInRestServer, "I wlll be cached!", 1);
            Cache.CacheEntry e = cache.getEntry(fileUri);
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((int)0, (int)e.getUpdateCount());
            this.listAndRead(pathInRestServer, "I wlll be cached!", 1);
            Assertions.assertEquals((int)(cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? 0 : 1), (int)e.getUpdateCount());
            Thread.sleep(1500L);
            try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.append("I wlll be cached!I wlll be cached!");
            }
            String expectedContents = cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? "I wlll be cached!" : "I wlll be cached!I wlll be cached!";
            this.listAndRead(pathInRestServer, expectedContents, 1);
            e = cache.getEntry(fileUri);
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((int)0, (int)e.getUpdateCount());
            this.listAndRead(pathInRestServer, expectedContents, 1);
            Assertions.assertEquals((int)(cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? 0 : 1), (int)e.getUpdateCount());
            Path pathInRestServer2 = restfs.getPath("testCache.txt2", new String[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer2, new OpenOption[0]);){
                writer.append("I wlll be cached!I wlll be cached!");
            }
            int expectedDirectorySize = cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? 1 : 2;
            this.listAndRead(pathInRestServer, expectedContents, expectedDirectorySize);
            Assertions.assertEquals((int)(cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? 0 : 2), (int)e.getUpdateCount());
            this.listAndRead(pathInRestServer, expectedContents, expectedDirectorySize);
            Assertions.assertEquals((int)(cacheMode == RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE ? 0 : 3), (int)e.getUpdateCount());
        }
    }

    @Test
    public void offlineCacheTest() throws IOException, URISyntaxException {
        TestServer testServer = new TestServer();
        URI restRootURI = UriBuilder.fromUri((URI)testServer.getServerURI()).scheme("ccs").build(new Object[0]);
        Path tempDir = Files.createTempDirectory("rfs", new FileAttribute[0]);
        Map env = RestFileSystemOptions.builder().cacheLocation(tempDir).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).set(RestFileSystemOptions.CacheFallback.OFFLINE).build();
        String content = "I wlll be cached!";
        String fileName = "testCache.txt";
        try (FileSystem restfs = FileSystems.newFileSystem(restRootURI, env);){
            Path pathInRestServer = restfs.getPath("testCache.txt", new String[0]);
            Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
            try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[0]);){
                writer.append("I wlll be cached!");
            }
            this.listAndRead(pathInRestServer, "I wlll be cached!", 1);
            testServer.shutdown();
        }
        var8_8 = null;
        try (FileSystem restfs2 = FileSystems.newFileSystem(restRootURI, env);){
            Path pathInRestServer2 = restfs2.getPath("testCache.txt", new String[0]);
            this.listAndRead(pathInRestServer2, "I wlll be cached!", 1);
            Path someOtherPath = restfs2.getPath("someOther.txt", new String[0]);
            Assertions.assertFalse((boolean)Files.exists(someOtherPath, new LinkOption[0]));
            try {
                Files.getLastModifiedTime(someOtherPath, new LinkOption[0]);
                Assertions.fail((String)"Should not get here");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer2, new OpenOption[0]);){
                    writer.append("I wlll be cached!");
                }
                Assertions.fail((String)"Should not get here");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Files.delete(pathInRestServer2);
                Assertions.fail((String)"Should not get here");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void cacheLockTest() throws URISyntaxException, IOException {
        Path tempDir = Files.createTempDirectory("rfs", new FileAttribute[0]);
        TestServer testServer = new TestServer();
        TestServer testServer2 = new TestServer(9998);
        try {
            URI restRootURI = UriBuilder.fromUri((URI)testServer.getServerURI()).scheme("ccs").build(new Object[0]);
            Map env = RestFileSystemOptions.builder().cacheLocation(tempDir).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).set(RestFileSystemOptions.CacheFallback.OFFLINE).build();
            try (FileSystem restfs = FileSystems.newFileSystem(restRootURI, env);){
                URI restRootURI2 = UriBuilder.fromUri((URI)testServer2.getServerURI()).scheme("ccs").build(new Object[0]);
                Map env2 = RestFileSystemOptions.builder().cacheLocation(tempDir).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).set(RestFileSystemOptions.CacheFallback.OFFLINE).build();
                try {
                    FileSystems.newFileSystem(restRootURI2, env2);
                    Assertions.fail();
                }
                catch (IOException x) {
                    Assertions.assertTrue((boolean)x.getMessage().contains("in use"));
                }
                env2.put("CacheFallbackLocation", true);
                FileSystem restfs2 = FileSystems.newFileSystem(restRootURI2, env2);
                Throwable throwable = null;
                if (restfs2 != null) {
                    if (throwable != null) {
                        try {
                            restfs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        restfs2.close();
                    }
                }
            }
        }
        finally {
            testServer.shutdown();
            testServer2.shutdown();
        }
    }

    private void listAndRead(Path path, String content, int expectedListSize) throws IOException {
        Assertions.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        Path parent = path.getParent();
        Assertions.assertTrue((boolean)Files.isDirectory(parent, new LinkOption[0]));
        List files = Files.list(parent).collect(Collectors.toList());
        Assertions.assertEquals((int)expectedListSize, (int)files.size());
        Assertions.assertTrue((boolean)Files.isSameFile(path, (Path)files.get(0)));
        List lines = Files.lines(path).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)content, lines.get(0));
        Assertions.assertEquals((long)content.length(), (long)Files.size(path));
        BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        Assertions.assertEquals((long)content.length(), (long)attributes.size());
        Assertions.assertEquals((Object)"text/plain", (Object)Files.probeContentType(path));
    }
}

