/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client;

import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;
import org.lsst.ccs.web.rest.file.server.TestServer;

public class RelativePathTest {
    private static TestServer testServer;
    private static FileSystem restfs;
    private static URI restRootURI;

    @BeforeAll
    public static void setUpClass() throws URISyntaxException, IOException {
        testServer = new TestServer();
        restRootURI = UriBuilder.fromUri((URI)testServer.getServerURI()).scheme("ccs").build(new Object[0]);
        restfs = FileSystems.newFileSystem(restRootURI, Collections.emptyMap());
    }

    @AfterAll
    public static void tearDownClass() throws IOException {
        restfs.close();
        testServer.shutdown();
    }

    @AfterEach
    public void cleanup() throws IOException {
        testServer.cleanFiles();
    }

    @Test
    public void relativePathTest() throws IOException {
        Path pathInRestServer = restfs.getPath("misc/test2.txt", new String[0]);
        Assertions.assertFalse((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
        Assertions.assertFalse((boolean)pathInRestServer.isAbsolute());
        pathInRestServer = pathInRestServer.toAbsolutePath();
        String content = "This is a test file";
        Files.createDirectory(pathInRestServer.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(pathInRestServer, new OpenOption[0]);){
            writer.append("This is a test file");
        }
        Assertions.assertTrue((boolean)Files.exists(pathInRestServer, new LinkOption[0]));
        URI mountPoint = URI.create("misc/");
        System.out.println(restRootURI);
        Map<String, URI> env = Collections.singletonMap("MountPoint", mountPoint);
        FileSystem relativefs = FileSystems.newFileSystem(restRootURI, env);
        Path relativePathInRestServer = relativefs.getPath("test2.txt", new String[0]);
        System.out.println(relativePathInRestServer);
        Assertions.assertTrue((boolean)Files.exists(relativePathInRestServer, new LinkOption[0]));
    }

    @Test
    public void shouldFailTest() throws IOException, URISyntaxException {
        try {
            FileSystems.newFileSystem(new URI("ccs://lsst-camera.slac.stanford.edu/RestFileServer"), Collections.emptyMap());
            Assertions.fail((String)"Should not get here");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void mountPointTest() throws IOException, URISyntaxException {
        URI mountPoint = URI.create("config/");
        Map<String, URI> env = Collections.singletonMap("MountPoint", mountPoint);
        RestFileSystem rfs = (RestFileSystem)FileSystems.newFileSystem(new URI("ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/"), env);
        rfs.close();
        rfs = (RestFileSystem)FileSystems.newFileSystem(new URI("ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/"), env);
        Assert.assertEquals((String)("Current mount point: " + rfs.getMountPoint() + " but expected \"config\""), (Object)"config/", (Object)rfs.getMountPoint().toString());
        rfs.close();
    }
}

