/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;

public class SpeedTest {
    @Test
    public void testSpeed() throws IOException {
        Path tempDir = Files.createTempDirectory("rfs", new FileAttribute[0]);
        URI uri = URI.create("ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/");
        Map env = RestFileSystemOptions.builder().cacheLocation(tempDir).set(RestFileSystemOptions.CacheOptions.MEMORY_AND_DISK).set(RestFileSystemOptions.CacheFallback.OFFLINE).build();
        FileSystem restfs = FileSystems.newFileSystem(uri, env);
        Path pathInRestServer = restfs.getPath("dictionaries/data/FocalPlane/3702060141.ser", new String[0]);
        long time1 = SpeedTest.readFile(pathInRestServer);
        long time2 = SpeedTest.readFile(pathInRestServer);
        Assert.assertTrue((time2 < time1 ? 1 : 0) != 0);
        ((RestFileSystem)restfs).getCache().setCacheFallbackOption(RestFileSystemOptions.CacheFallback.WHEN_POSSIBLE);
        long time3 = SpeedTest.readFile(pathInRestServer);
        Assert.assertTrue((time3 <= time2 ? 1 : 0) != 0);
        Path pathInRestServer2 = restfs.getPath("dictionaries/command/FocalPlane/846244239.ser", new String[0]);
        long time4 = SpeedTest.readFile(pathInRestServer2);
        Assert.assertTrue((time4 < time1 ? 1 : 0) != 0);
        long time5 = SpeedTest.readFile(pathInRestServer2);
        Assert.assertTrue((time5 < time4 ? 1 : 0) != 0);
        ((RestFileSystem)restfs).getCache().setCacheFallbackOption(RestFileSystemOptions.CacheFallback.OFFLINE);
        long time6 = SpeedTest.readFile(pathInRestServer2);
        Assert.assertTrue((time5 <= time6 ? 1 : 0) != 0);
        Assert.assertTrue((time6 < time4 ? 1 : 0) != 0);
        restfs.close();
    }

    private static long readFile(Path pathInRestServer) throws IOException {
        byte[] buffer = new byte[32768];
        int length = 0;
        long start = System.currentTimeMillis();
        try (InputStream inputStream = Files.newInputStream(pathInRestServer, new OpenOption[0]);){
            int l;
            while ((l = inputStream.read(buffer, length, buffer.length - length)) >= 0) {
                length += l;
            }
        }
        long stop = System.currentTimeMillis();
        long delta = stop - start;
        System.out.printf("Read %d bytes in %dms\n", length, delta);
        return delta;
    }
}

