/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.IOException;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.rest.file.server.client.implementation.UnixPath;

public class AbstractUnixlikePathTest {
    @Test
    public void rootTest() {
        UnixPath.Builder builder = new UnixPath.Builder();
        Path root = builder.getPath("/", new String[0]);
        Assertions.assertEquals((Object)root, (Object)root.getRoot());
    }

    @Test
    public void normalizeTest() {
        UnixPath.Builder builder = new UnixPath.Builder();
        Path abc = builder.getPath("a/b/c", new String[0]);
        Assertions.assertEquals((Object)abc, (Object)abc.normalize());
        Path withDots = builder.getPath("a/./c", new String[0]);
        Assertions.assertEquals((Object)"a/c", (Object)withDots.normalize().toString());
        Path withDoubleDots = builder.getPath("a/../c", new String[0]);
        Assertions.assertEquals((Object)"c", (Object)withDoubleDots.normalize().toString());
        Path startWithDoubleDots = builder.getPath("../../c", new String[0]);
        Assertions.assertEquals((Object)"../../c", (Object)startWithDoubleDots.normalize().toString());
        Path moreDoubleDots = builder.getPath("/../../c", new String[0]);
        Assertions.assertEquals((Object)"/../../c", (Object)moreDoubleDots.normalize().toString());
    }

    @Test
    public void relativizeTest() throws IOException {
        UnixPath.Builder builder = new UnixPath.Builder();
        Path path1 = builder.getPath("a", "b", "c");
        Path path2 = builder.getPath("a", new String[0]);
        Path path3 = path2.relativize(path1);
        Assertions.assertEquals((Object)"b/c", (Object)path3.toString());
        Path path4 = path1.relativize(path2);
        Assertions.assertEquals((Object)"../..", (Object)path4.toString());
    }
}

