/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import org.lsst.ccs.rest.file.server.client.VersionOption;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributeView;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;
import org.lsst.ccs.rest.file.server.client.implementation.AbstractPath;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileAttributes;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;
import org.lsst.ccs.rest.file.server.client.implementation.RestVersionedFileAttributes;
import org.lsst.ccs.web.rest.file.server.data.IOExceptionResponse;
import org.lsst.ccs.web.rest.file.server.data.RestFileInfo;
import org.lsst.ccs.web.rest.file.server.data.VersionInfo;

class RestPath
extends AbstractPath {
    private final RestFileSystem fileSystem;
    private final LinkedList<String> path;
    private final boolean isReadOnly;
    private final boolean isAbsolute;

    RestPath(RestFileSystem fileSystem, String path, boolean isReadOnly) {
        this.fileSystem = fileSystem;
        this.path = new LinkedList<String>(Arrays.asList(path.split("/")));
        this.isReadOnly = isReadOnly;
        this.isAbsolute = path.startsWith("/");
    }

    RestPath(RestFileSystem fileSystem, List<String> path, boolean isReadOnly, boolean isAbsolute) {
        this.fileSystem = fileSystem;
        this.path = new LinkedList<String>(path);
        this.isReadOnly = isReadOnly;
        this.isAbsolute = isAbsolute;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public Path getRoot() {
        return this.fileSystem.getRootDirectories().iterator().next();
    }

    @Override
    public Path getFileName() {
        return new RestPath(this.fileSystem, this.path.getLast(), this.isReadOnly);
    }

    @Override
    public Path getParent() {
        return this.path.isEmpty() ? null : new RestPath(this.fileSystem, this.path.subList(0, this.path.size() - 1), this.isReadOnly, this.isAbsolute);
    }

    @Override
    public int getNameCount() {
        return this.path.size();
    }

    @Override
    public Path getName(int index) {
        return new RestPath(this.fileSystem, this.path.get(index), this.isReadOnly);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Path normalize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Path relativize(Path other) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public URI toUri() {
        return this.fileSystem.getURI(this.path);
    }

    @Override
    public Path toAbsolutePath() {
        if (this.isAbsolute) {
            return this;
        }
        return new RestPath(this.fileSystem, this.path, this.isReadOnly, true);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int compareTo(Path other) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String toString() {
        return (this.isAbsolute ? "/" : "") + String.join((CharSequence)"/", this.path);
    }

    InputStream newInputStream(OpenOption[] options) throws IOException {
        if (this.isVersionedFile()) {
            VersionOption vo = this.getOptions(options, VersionOption.class);
            if (vo == null) {
                vo = VersionOption.DEFAULT;
            }
            URI uri = this.fileSystem.getRestURI("rest/version/download/", this.path);
            uri = UriBuilder.fromUri((URI)uri).queryParam("version", new Object[]{vo.value()}).build(new Object[0]);
            return uri.toURL().openStream();
        }
        URI uri = this.fileSystem.getRestURI("rest/download/", this.path);
        return uri.toURL().openStream();
    }

    OutputStream newOutputStream(OpenOption[] options) throws IOException {
        VersionOpenOption voo = this.getOptions(options, VersionOpenOption.class);
        String restPath = this.isVersionedFile() || voo != null ? "rest/version/upload/" : "rest/upload/";
        URI uri = this.fileSystem.getRestURI(restPath, this.path);
        final ArrayBlockingQueue<Future> queue = new ArrayBlockingQueue<Future>(1);
        PipedOutputStream out = new PipedOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    Response response = (Response)((Future)queue.take()).get();
                    RestPath.this.checkResponse(response);
                }
                catch (InterruptedException x) {
                    throw new InterruptedIOException("Interrupt during file close");
                }
                catch (ExecutionException x) {
                    throw new IOException("Error during file close", x.getCause());
                }
            }
        };
        Client client = ClientBuilder.newClient();
        PipedInputStream in = new PipedInputStream(out);
        Future futureResponse = client.target(uri).request(new String[]{"application/json"}).async().post(Entity.entity((Object)in, (String)"application/octet-stream"));
        queue.add(futureResponse);
        return out;
    }

    void move(RestPath target, CopyOption[] options) throws IOException {
        Client client = ClientBuilder.newClient();
        URI uri = UriBuilder.fromUri((URI)this.fileSystem.getRestURI("rest/move/", this.path)).queryParam("target", new Object[]{String.join((CharSequence)"/", target.path)}).build(new Object[0]);
        Response response = client.target(uri).request(new String[]{"application/json"}).get();
        this.checkResponse(response);
    }

    private <T extends OpenOption> T getOptions(OpenOption[] options, Class<T> optionClass) {
        for (OpenOption option : options) {
            if (!optionClass.isInstance(option)) continue;
            return (T)((OpenOption)optionClass.cast(option));
        }
        return null;
    }

    BasicFileAttributes getAttributes() throws IOException {
        if (this.isVersionedFile()) {
            VersionInfo info = this.getVersionedRestFileInfo();
            return new RestFileAttributes((RestFileInfo)info.getVersions().get(info.getDefault() - 1));
        }
        RestFileInfo info = this.getRestFileInfo();
        return new RestFileAttributes(info);
    }

    VersionedFileAttributes getVersionedAttributes() throws IOException {
        if (!this.isVersionedFile()) {
            throw new IOException("Cannot read versioned attributes for non-versioned file");
        }
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.fileSystem.getRestURI("rest/version/info/", this.path)).request(new String[]{"application/json"}).get();
        this.checkResponse(response);
        VersionInfo info = (VersionInfo)response.readEntity(VersionInfo.class);
        return new RestVersionedFileAttributes(info);
    }

    private VersionInfo getVersionedRestFileInfo() throws IOException {
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.fileSystem.getRestURI("rest/version/info/", this.path)).request(new String[]{"application/json"}).get();
        this.checkResponse(response);
        VersionInfo info = (VersionInfo)response.readEntity(VersionInfo.class);
        return info;
    }

    private RestFileInfo getRestFileInfo() throws IOException {
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.fileSystem.getRestURI("rest/info/", this.path)).request(new String[]{"application/json"}).get();
        this.checkResponse(response);
        RestFileInfo info = (RestFileInfo)response.readEntity(RestFileInfo.class);
        return info;
    }

    private void checkResponse(Response response) throws IOException {
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            if (response.getStatus() == 406) {
                IOExceptionResponse ioError = (IOExceptionResponse)response.readEntity(IOExceptionResponse.class);
                try {
                    Class<IOException> exceptionClass = Class.forName(ioError.getExceptionClass()).asSubclass(IOException.class);
                    Constructor<IOException> constructor = exceptionClass.getConstructor(String.class);
                    IOException io = constructor.newInstance(ioError.getMessage());
                    throw io;
                }
                catch (ReflectiveOperationException ex) {
                    throw new IOException("Remote Exception " + ioError.getExceptionClass() + " " + ioError.getMessage());
                }
            }
            throw new IOException("Response code " + response.getStatus() + " " + response.getStatusInfo());
        }
    }

    BasicFileAttributeView getFileAttributeView() {
        return new BasicFileAttributeView(){

            @Override
            public String name() {
                return "basic";
            }

            @Override
            public BasicFileAttributes readAttributes() throws IOException {
                return RestPath.this.getAttributes();
            }

            @Override
            public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    VersionedFileAttributeView getVersionedAttributeView() {
        return new VersionedFileAttributeView(){

            @Override
            public void setDefaultVersion(int version) throws IOException {
                Client client = ClientBuilder.newClient();
                URI uri = RestPath.this.fileSystem.getRestURI("rest/version/set/", RestPath.this.path);
                Response response = client.target(uri).request(new String[]{"application/json"}).put(Entity.entity((Object)version, (String)"application/json"));
                RestPath.this.checkResponse(response);
            }

            @Override
            public String name() {
                return "versioned";
            }

            @Override
            public VersionedFileAttributes readAttributes() throws IOException {
                return RestPath.this.getVersionedAttributes();
            }
        };
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.fileSystem.getRestURI("rest/list/", this.path)).request(new String[]{"application/json"}).get();
        this.checkResponse(response);
        response.readEntity(RestFileInfo.class);
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.fileSystem.getRestURI("rest/list/", this.path)).request(new String[]{"application/json"}).get();
        this.checkResponse(response);
        RestFileInfo dirList = (RestFileInfo)response.readEntity(RestFileInfo.class);
        final List paths = dirList.getChildren().stream().map(fileInfo -> {
            ArrayList<String> newPath = new ArrayList<String>(this.path);
            newPath.add(fileInfo.getName());
            return new RestPath(this.fileSystem, newPath, this.isReadOnly, true);
        }).collect(Collectors.toList());
        return new DirectoryStream<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return paths.iterator();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    void delete() throws IOException {
        Client client = ClientBuilder.newClient();
        String restPath = this.isVersionedFile() ? "rest/version/deleteFile/" : "rest/deleteFile/";
        Response response = client.target(this.fileSystem.getRestURI(restPath, this.path)).request(new String[]{"application/json"}).delete();
        this.checkResponse(response);
    }

    void createDirectory(FileAttribute<?>[] attrs) throws IOException {
        Client client = ClientBuilder.newClient();
        Response response = client.target(this.fileSystem.getRestURI("rest/createDirectory/", this.path)).request(new String[]{"application/json"}).get();
        this.checkResponse(response);
    }

    Map<String, Object> readAttributes(String attributes) throws IOException {
        return this.getRestFileInfo().getAsMap();
    }

    private boolean isVersionedFile() throws IOException {
        try {
            RestFileInfo info = this.getRestFileInfo();
            return info.isVersionedFile();
        }
        catch (FileNotFoundException | NoSuchFileException x) {
            return false;
        }
    }

    @Override
    public boolean startsWith(Path other) {
        if (!other.getFileSystem().equals(this.getFileSystem())) {
            return false;
        }
        RestPath otherPath = (RestPath)other;
        if (otherPath.path.size() > this.path.size()) {
            return false;
        }
        for (int i = 0; i < otherPath.path.size(); ++i) {
            if (otherPath.path.get(i).equals(this.path.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(Path other) {
        if (!other.getFileSystem().equals(this.getFileSystem())) {
            return false;
        }
        RestPath otherPath = (RestPath)other;
        if (otherPath.path.size() > this.path.size()) {
            return false;
        }
        for (int i = otherPath.path.size() - 1; i > 0; --i) {
            if (otherPath.path.get(i).equals(this.path.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        if (other.getNameCount() == 0) {
            return this;
        }
        LinkedList<String> newPath = new LinkedList<String>(this.path);
        for (int i = 0; i < other.getNameCount(); ++i) {
            newPath.add(other.getName(i).toString());
        }
        return new RestPath(this.fileSystem, newPath, this.isReadOnly, this.isAbsolute);
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.fileSystem);
        hash = 89 * hash + Objects.hashCode(this.path);
        hash = 89 * hash + (this.isAbsolute ? 1 : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestPath other = (RestPath)obj;
        if (this.isAbsolute != other.isAbsolute) {
            return false;
        }
        if (!Objects.equals(this.fileSystem, other.fileSystem)) {
            return false;
        }
        return Objects.equals(this.path, other.path);
    }

    boolean isSameFile(RestPath other) {
        return this.toAbsolutePath().equals(other.toAbsolutePath());
    }
}

