/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributeView;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;
import org.lsst.ccs.rest.file.server.client.implementation.RestFileSystem;
import org.lsst.ccs.rest.file.server.client.implementation.RestPath;

public class RestFileSystemProvider
extends FileSystemProvider {
    private final Map<URI, RestFileSystem> cache = new ConcurrentHashMap<URI, RestFileSystem>();

    @Override
    public String getScheme() {
        return "ccs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        Map<URI, RestFileSystem> map = this.cache;
        synchronized (map) {
            RestFileSystem result = this.cache.get(uri);
            if (result == null) {
                result = new RestFileSystem(this, uri, env);
                this.cache.put(uri, result);
            }
            return result;
        }
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        return this.cache.get(uri);
    }

    @Override
    public Path getPath(URI uri) {
        if (!this.getScheme().equals(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported scheme " + uri);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return this.toRestPath(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return this.toRestPath(path).newOutputStream(options);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.toRestPath(dir).newDirectoryStream(filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        this.toRestPath(dir).createDirectory(attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.toRestPath(path).delete();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        this.toRestPath(source).move(this.toRestPath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        if (path == path2) {
            return true;
        }
        if (path.getFileSystem() != path2.getFileSystem()) {
            return false;
        }
        return this.toRestPath(path).isSameFile(this.toRestPath(path2));
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        this.toRestPath(path).checkAccess(modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == BasicFileAttributeView.class) {
            return (V)((FileAttributeView)type.cast(this.toRestPath(path).getFileAttributeView()));
        }
        if (type == VersionedFileAttributeView.class) {
            return (V)((FileAttributeView)type.cast(this.toRestPath(path).getVersionedAttributeView()));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class) {
            return (A)((BasicFileAttributes)type.cast(this.toRestPath(path).getAttributes()));
        }
        if (type == VersionedFileAttributes.class) {
            return (A)((BasicFileAttributes)type.cast(this.toRestPath(path).getVersionedAttributes()));
        }
        return null;
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return this.toRestPath(path).readAttributes(attributes);
    }

    private RestPath toRestPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof RestPath)) {
            throw new ProviderMismatchException();
        }
        return (RestPath)path;
    }
}

