/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.lsst.ccs.rest.file.server.cli.TopLevelCommand;
import org.lsst.ccs.rest.file.server.cli.Utils;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import picocli.CommandLine;

@CommandLine.Command(name="cat", description={"Write the contents of a file to standard output"})
public class CatCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private TopLevelCommand parent;
    @CommandLine.Parameters(paramLabel="<path>", description={"Path to file to cat"})
    private String path;
    @CommandLine.Option(names={"-v", "--version"}, description={"If a versioned file, the version to cat. "}, defaultValue="default", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String version;
    @CommandLine.Option(names={"-c", "--create"}, description={"Create a new file by reading from stdin"})
    private boolean create;
    @CommandLine.Option(names={"-n", "--versioned"}, description={"Create a new versioned file by reading from stdin"})
    private boolean createVersioned;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @Override
    public Void call() throws IOException {
        try (FileSystem restfs = this.parent.createFileSystem();){
            Utils.OpenOptionsBuilder builder;
            Path restPath = restfs.getPath(this.path, new String[0]);
            if (!this.create && !this.createVersioned) {
                builder = Utils.openOptionsBuilder(new OpenOption[0]);
                boolean isVersionedFile = (Boolean)Files.getAttribute(restPath, "isVersionedFile", new LinkOption[0]);
                if (isVersionedFile) {
                    builder.add((OpenOption)VersionOpenOption.of((String)this.version));
                }
                try (InputStream in = Files.newInputStream(restPath, builder.build());){
                    Utils.copy(in, System.out);
                }
            }
            builder = Utils.openOptionsBuilder(new OpenOption[0]);
            if (this.createVersioned) {
                builder.add((OpenOption)VersionOpenOption.LATEST);
            }
            try (OutputStream out = Files.newOutputStream(restPath, builder.build());){
                Utils.copy(System.in, out);
            }
            Void void_ = null;
            return void_;
        }
    }
}

