/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import org.lsst.ccs.rest.file.server.cli.TopLevelCommand;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import picocli.CommandLine;

@CommandLine.Command(name="edit", description={"Edit a file on the rest file server"})
public class EditCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private TopLevelCommand parent;
    @CommandLine.Option(names={"-e", "--editor"}, description={"Editor command to use, defaults to $EDITOR if defined, otherwise vi"})
    private String editor;
    @CommandLine.Option(names={"-v", "--version"}, description={"If a versioned file, the version to edit"}, defaultValue="latest", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String version;
    @CommandLine.Parameters(paramLabel="<path>", description={"Path to edit"})
    private String path;

    @Override
    public Void call() throws Exception {
        try (FileSystem restfs = this.parent.createFileSystem();){
            OpenOption[] openOptionArray;
            Path restPath = restfs.getPath(this.path, new String[0]);
            boolean isVersionedFile = (Boolean)Files.getAttribute(restPath, "isVersionedFile", new LinkOption[0]);
            Path tempPath = Files.createTempFile("rest-file-server", "edit", new FileAttribute[0]);
            if (isVersionedFile) {
                OpenOption[] openOptionArray2 = new OpenOption[1];
                openOptionArray = openOptionArray2;
                openOptionArray2[0] = VersionOpenOption.of((String)this.version);
            } else {
                openOptionArray = new OpenOption[]{};
            }
            OpenOption[] options = openOptionArray;
            try (InputStream in = Files.newInputStream(restPath, options);){
                Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
            }
            if (this.invokeEditor(tempPath)) {
                if (isVersionedFile) {
                    var8_11 = null;
                    try (OutputStream out = Files.newOutputStream(restPath, new OpenOption[0]);){
                        Files.copy(tempPath, out);
                    }
                    catch (Throwable throwable) {
                        var8_11 = throwable;
                        throw throwable;
                    }
                    int latestVersion = (Integer)Files.getAttribute(restPath, "latestVersion", new LinkOption[0]);
                    System.out.printf("New version (%d) was created\n", latestVersion);
                } else {
                    Files.copy(tempPath, restPath, StandardCopyOption.REPLACE_EXISTING);
                    System.out.println("File was updated");
                }
            }
            Void void_ = null;
            return void_;
        }
    }

    private boolean invokeEditor(Path tempPath) throws IOException, InterruptedException {
        FileTime originalModificationTime = Files.getLastModifiedTime(tempPath, new LinkOption[0]);
        Checksum originalChecksum = this.computeChecksum(tempPath);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String editorCommand = this.editor != null ? this.editor : (System.getenv("EDITOR") == null ? "vi" : System.getenv("EDITOR"));
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(editorCommand.split("\\s+")));
        command.add(tempPath.toString());
        builder.command(command);
        builder.inheritIO();
        builder.redirectErrorStream(true);
        Process editorProcess = builder.start();
        try (BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(editorProcess.getInputStream()));){
            String line;
            while ((line = errorStreamReader.readLine()) != null) {
                System.out.println(line);
            }
        }
        int rc = editorProcess.waitFor();
        if (rc != 0) {
            throw new IOException("Editor exited with rc=" + rc);
        }
        return Files.getLastModifiedTime(tempPath, new LinkOption[0]).compareTo(originalModificationTime) > 0 && this.computeChecksum(tempPath).getValue() != originalChecksum.getValue();
    }

    private Checksum computeChecksum(Path tempPath) throws IOException {
        OutputStream nullOutputStream = new OutputStream(){

            @Override
            public void write(int b) {
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
            }
        };
        CheckedOutputStream checkedOutputStream = new CheckedOutputStream(nullOutputStream, new CRC32());
        Files.copy(tempPath, checkedOutputStream);
        return checkedOutputStream.getChecksum();
    }
}

