/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

public class FileSizeFormatter {
    private final boolean humanReadable;
    private final boolean si;

    FileSizeFormatter(boolean humanReadable, boolean si) {
        this.humanReadable = humanReadable;
        this.si = si;
    }

    String format(long size) {
        if (this.humanReadable) {
            return FileSizeFormatter.humanReadableByteCount(size, this.si);
        }
        return String.format("%d", size);
    }

    private static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + "";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "");
        return String.format("%.1f%s", (double)bytes / Math.pow(unit, exp), pre);
    }
}

