/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class FileDateFormatter {
    private static final Duration SWITCH_FORMAT_AGE = Duration.ofDays(200L);
    private static final DateTimeFormatter RECENT_FORMAT = DateTimeFormatter.ofPattern("MMM dd HH:mm");
    private static final DateTimeFormatter AGED_FORMAT = DateTimeFormatter.ofPattern("MMM dd  YYYY");
    private static final DateTimeFormatter FULL_FORMAT = DateTimeFormatter.ofPattern("YYYY-MM-DD hh:mm:ss");
    private final boolean fullTime;
    private final Instant referenceTime;

    FileDateFormatter(boolean fullTime) {
        this.fullTime = fullTime;
        this.referenceTime = Instant.now();
    }

    String format(FileTime time) {
        Instant timeStamp = time.toInstant();
        Duration age = Duration.between(this.referenceTime, timeStamp);
        DateTimeFormatter formatter = this.fullTime ? FULL_FORMAT : (age.compareTo(SWITCH_FORMAT_AGE) < 0 ? RECENT_FORMAT : AGED_FORMAT);
        return formatter.withZone(ZoneId.systemDefault()).format(timeStamp);
    }
}

