/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.lsst.ccs.rest.file.server.cli.TopLevelCommand;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributeView;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Modify settings on a versioned file"})
public class SetCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private TopLevelCommand parent;
    @CommandLine.Parameters(paramLabel="<path>", description={"Path to file"})
    private String path;
    @CommandLine.Option(names={"-v", "--version"}, description={"The version to use. "}, defaultValue="default", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String version;
    @CommandLine.Option(names={"-d", "--default"}, description={"Make this the default version"})
    private boolean makeDefault;
    @CommandLine.Option(names={"-c", "--comment"}, description={"Comment for specified version"})
    private String comment;
    @CommandLine.Option(names={"-h", "--hidden"}, description={"Hide specified version"})
    private Boolean hidden;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @Override
    public Void call() throws IOException {
        try (FileSystem restfs = this.parent.createFileSystem();){
            Path restPath = restfs.getPath(this.path, new String[0]);
            boolean isVersionedFile = (Boolean)Files.getAttribute(restPath, "isVersionedFile", new LinkOption[0]);
            if (!isVersionedFile) {
                throw new IllegalArgumentException("Not a versioned file");
            }
            VersionedFileAttributeView versionView = Files.getFileAttributeView(restPath, VersionedFileAttributeView.class, new LinkOption[0]);
            VersionedFileAttributes attributes = versionView.readAttributes();
            VersionOpenOption voo = VersionOpenOption.of((String)this.version);
            int intVersion = voo.getIntVersion(attributes);
            if (this.makeDefault) {
                versionView.setDefaultVersion(intVersion);
            }
            if (this.comment != null) {
                versionView.setComment(intVersion, this.comment);
            }
            if (this.hidden != null) {
                versionView.setHidden(intVersion, this.hidden.booleanValue());
            }
            Void void_ = null;
            return void_;
        }
    }
}

