/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.lsst.ccs.rest.file.server.cli.TopLevelCommand;
import org.lsst.ccs.rest.file.server.cli.Utils;
import org.lsst.ccs.rest.file.server.client.VersionOpenOption;
import org.lsst.ccs.rest.file.server.client.VersionedOpenOption;
import picocli.CommandLine;

@CommandLine.Command(name="diff", description={"Show diffs for versioned file"})
public class DiffCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private TopLevelCommand parent;
    @CommandLine.Parameters(paramLabel="<path>", description={"Path to file to diff"})
    private String path;
    @CommandLine.Option(names={"-v", "--version"}, description={"The version to diff. By default the latest"}, defaultValue="latest", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String v1;
    @CommandLine.Option(names={"-v2"}, description={"The version to diff against"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String v2;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @Override
    public Void call() throws IOException {
        try (FileSystem restfs = this.parent.createFileSystem();){
            Path restPath = restfs.getPath(this.path, new String[0]);
            boolean isVersionedFile = (Boolean)Files.getAttribute(restPath, "isVersionedFile", new LinkOption[0]);
            if (!isVersionedFile) {
                throw new IllegalArgumentException("Not a versioned file");
            }
            Utils.OpenOptionsBuilder builder = Utils.openOptionsBuilder(new OpenOption[0]);
            builder.add((OpenOption)VersionedOpenOption.DIFF);
            if (this.v1 != null) {
                builder.add((OpenOption)VersionOpenOption.of((String)this.v1));
            }
            if (this.v2 != null) {
                builder.add((OpenOption)VersionOpenOption.of((String)this.v2));
            }
            try (InputStream in = Files.newInputStream(restPath, builder.build());){
                Utils.copy(in, System.out);
            }
            Void void_ = null;
            return void_;
        }
    }
}

