/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.lsst.ccs.rest.file.server.cli.FileDateFormatter;
import org.lsst.ccs.rest.file.server.cli.FileSizeFormatter;
import org.lsst.ccs.rest.file.server.cli.TopLevelCommand;
import org.lsst.ccs.rest.file.server.client.VersionedFileAttributes;
import picocli.CommandLine;

@CommandLine.Command(name="ls", usageHelpAutoWidth=true, description={"List files on remove rest file server"})
public class ListCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private TopLevelCommand parent;
    @CommandLine.Option(names={"-l", "--long"}, description={"Detailed listing"})
    private boolean showLong;
    @CommandLine.Option(names={"-a", "--all"}, description={"Include hidden files"})
    private boolean showAll;
    @CommandLine.Option(names={"-h", "--human-readable"}, description={"with -l, print sizes in human readable format (e.g., 1K 234M 2G)"})
    private boolean humanReadable;
    @CommandLine.Option(names={"--si"}, description={"like -h, but use powers of 1000 not 1024"})
    private boolean si;
    @CommandLine.Option(names={"--color"}, description={"colorize the output"}, defaultValue="true", negatable=true, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private boolean colorize;
    @CommandLine.Option(names={"--full-time"}, description={"Show full date format (with -l)"})
    private boolean fullTime;
    @CommandLine.Parameters(paramLabel="<path>", defaultValue="/", description={"Path to list"})
    private String path;

    @Override
    public Void call() throws IOException {
        try (FileSystem restfs = this.parent.createFileSystem();){
            CommandLine.Help.Ansi ansi;
            Path restPath = restfs.getPath(this.path, new String[0]);
            boolean isDirectory = Files.isDirectory(restPath, new LinkOption[0]);
            boolean isVersionedFile = (Boolean)Files.getAttribute(restPath, "isVersionedFile", new LinkOption[0]);
            FileSizeFormatter fsf = new FileSizeFormatter(this.humanReadable, this.si);
            FileDateFormatter fdf = new FileDateFormatter(this.fullTime);
            CommandLine.Help.Ansi ansi2 = ansi = this.colorize ? CommandLine.Help.Ansi.AUTO : CommandLine.Help.Ansi.OFF;
            if (isDirectory) {
                Stream<Path> directoryStream = Files.list(restPath);
                Object object = null;
                try {
                    directoryStream.forEach(p -> {
                        try {
                            String color;
                            BasicFileAttributes bfa = Files.readAttributes(p, BasicFileAttributes.class, new LinkOption[0]);
                            String string = bfa.isDirectory() ? "blue" : (color = bfa.isOther() ? "green" : "white");
                            if (this.showLong || this.si) {
                                String line = String.format("@|%s %10s %s %s|@", color, fsf.format(bfa.size()), fdf.format(bfa.lastModifiedTime()), p.getFileName());
                                System.out.println(ansi.string(line));
                            } else {
                                String line = String.format("@|%s %s|@", color, p.getFileName());
                                System.out.println(ansi.string(line));
                            }
                        }
                        catch (IOException x) {
                            System.out.println("IOException: " + p.getFileName());
                        }
                    });
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (directoryStream != null) {
                        if (object != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            directoryStream.close();
                        }
                    }
                }
            } else if (isVersionedFile) {
                VersionedFileAttributes vfa = Files.readAttributes(restPath, VersionedFileAttributes.class, new LinkOption[0]);
                for (Object version : (Object)vfa.getVersions()) {
                    String line;
                    if (!this.showAll && vfa.isHidden((int)version)) continue;
                    BasicFileAttributes bfa = vfa.getAttributes((int)version);
                    String color = version == vfa.getDefaultVersion() ? "blue" : (version == vfa.getLatestVersion() ? "green" : "white");
                    ArrayList<String> attributes = new ArrayList<String>();
                    if (version == vfa.getDefaultVersion()) {
                        attributes.add("default");
                    }
                    if (version == vfa.getLatestVersion()) {
                        attributes.add("latest");
                    }
                    if (vfa.isHidden((int)version)) {
                        attributes.add("hidden");
                    }
                    String info = String.join((CharSequence)",", attributes);
                    String comment = vfa.getComment((int)version);
                    if (this.showLong || this.si) {
                        line = String.format("@|%s %10s %s %3d %s \"%s\"|@", color, fsf.format(bfa.size()), fdf.format(bfa.lastModifiedTime()), (int)version, info, comment);
                        System.out.println(ansi.string(line));
                        continue;
                    }
                    line = String.format("@|%s %3d %s|@", color, (int)version, info);
                    System.out.println(ansi.string(line));
                }
            } else {
                throw new NotDirectoryException("Not a directory or versioned file: " + this.path);
            }
            Void void_ = null;
            return void_;
        }
    }
}

