/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.cli;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.HashMap;
import org.lsst.ccs.rest.file.server.cli.CatCommand;
import org.lsst.ccs.rest.file.server.cli.DiffCommand;
import org.lsst.ccs.rest.file.server.cli.EditCommand;
import org.lsst.ccs.rest.file.server.cli.ListCommand;
import org.lsst.ccs.rest.file.server.cli.MakeDirectoryCommand;
import org.lsst.ccs.rest.file.server.cli.MoveCommand;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;
import picocli.CommandLine;

@CommandLine.Command(name="cfs", usageHelpAutoWidth=true, subcommands={CatCommand.class, EditCommand.class, ListCommand.class, DiffCommand.class, MoveCommand.class, MakeDirectoryCommand.class, CommandLine.HelpCommand.class})
public class TopLevelCommand {
    @CommandLine.Option(names={"-r", "--rest-server"}, defaultValue="ccs://lsst-camera-dev.slac.stanford.edu/RestFileServer/", description={"Rest file server to connect to"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String restServer;
    @CommandLine.Option(names={"--help"}, usageHelp=true, description={"display this help and exit"})
    private boolean help;
    @CommandLine.Option(names={"--cacheOptions"}, description={"Caching options for file system"})
    private RestFileSystemOptions.CacheOptions cacheOptions;
    @CommandLine.Option(names={"--cacheFallback"}, description={"Caching fallback options for file system"})
    private RestFileSystemOptions.CacheFallback cacheFallback;
    @CommandLine.Option(names={"--cacheDir"}, description={"Directory to use for disk cache"})
    private File cacheLocation;
    @CommandLine.Option(names={"--cacheLog"}, description={"Log caching operations"})
    private boolean logCaching;

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new TopLevelCommand()).execute(args);
        System.exit(exitCode);
    }

    FileSystem createFileSystem() throws IOException {
        URI uri = URI.create(this.restServer);
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (this.cacheOptions != null) {
            options.put("CacheOptions", this.cacheOptions);
        }
        if (this.cacheFallback != null) {
            options.put("CacheFallback", this.cacheFallback);
        }
        if (this.cacheLocation != null) {
            options.put("CacheLocation", this.cacheLocation);
        }
        options.put("CacheLogging", this.logCaching);
        return FileSystems.newFileSystem(uri, options);
    }
}

