/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IBaseStyle;
import hep.aida.IDataStyle;
import hep.aida.IFillStyle;
import hep.aida.ILineStyle;
import hep.aida.IMarkerStyle;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.plotter.BaseStyle;
import hep.aida.ref.plotter.BooleanStyleParameter;
import hep.aida.ref.plotter.DoubleStyleParameter;
import hep.aida.ref.plotter.FillStyle;
import hep.aida.ref.plotter.LineStyle;
import hep.aida.ref.plotter.MarkerStyle;
import hep.aida.ref.plotter.StringStyleParameter;

public class DataStyle
extends BaseStyle
implements IDataStyle {
    @Override
    protected void initializeBaseStyle() {
        this.setMarkerStyle(new MarkerStyle());
        this.setLineStyle(new LineStyle());
        this.setFillStyle(new FillStyle());
        this.setErrorBarStyle(new LineStyle());
        this.setOutlineStyle(new LineStyle());
        this.addParameter(new StringStyleParameter("customOverlay", null));
        this.addParameter(new StringStyleParameter("timeZone", null));
        this.addParameter(new StringStyleParameter("model", null));
        String[] normalization = new String[]{"none", "Entries", "Area", "MaxBin"};
        this.addParameter(new StringStyleParameter("normalization", normalization[0], normalization));
        String[] profileErrors = new String[]{"spread", "errorOnMean"};
        this.addParameter(new StringStyleParameter("profileErrors", profileErrors[0], profileErrors));
        this.addParameter(new BooleanStyleParameter("showDataInStatisticsBox", true));
        this.addParameter(new BooleanStyleParameter("showDataInLegendBox", true));
        ((BaseStyle)this.outlineStyle()).setParameterDefault("isVisible", "false");
        ((BaseStyle)this.markerStyle()).setParameterDefault("isVisible", "false");
    }

    public IFillStyle fillStyle() {
        return (IFillStyle)this.child("fillStyle");
    }

    public ILineStyle lineStyle() {
        return (ILineStyle)this.child("lineStyle");
    }

    public IMarkerStyle markerStyle() {
        return (IMarkerStyle)this.child("markerStyle");
    }

    public ILineStyle errorBarStyle() {
        return (ILineStyle)this.child("errorBarStyle");
    }

    public ILineStyle outlineStyle() {
        return (ILineStyle)this.child("outlineStyle");
    }

    public boolean setFillStyle(IFillStyle fillStyle) {
        return this.addBaseStyle((IBaseStyle)fillStyle, "fillStyle");
    }

    public boolean setLineStyle(ILineStyle lineStyle) {
        return this.addBaseStyle((IBaseStyle)lineStyle, "lineStyle");
    }

    public boolean setMarkerStyle(IMarkerStyle markerStyle) {
        return this.addBaseStyle((IBaseStyle)markerStyle, "markerStyle");
    }

    public boolean setErrorBarStyle(ILineStyle errorBarStyle) {
        int index = AidaUtils.findInArray("errorBarDecoration", errorBarStyle.availableParameters());
        if (index < 0 && errorBarStyle instanceof LineStyle) {
            ((LineStyle)errorBarStyle).addParameter(new DoubleStyleParameter("errorBarDecoration", -1.0));
        }
        return this.addBaseStyle((IBaseStyle)errorBarStyle, "errorBarStyle");
    }

    public boolean setOutlineStyle(ILineStyle outlineStyle) {
        return this.addBaseStyle((IBaseStyle)outlineStyle, "outlineStyle");
    }

    public boolean setModel(String model) {
        return ((StringStyleParameter)this.parameter("model")).setValue(model);
    }

    public String model() {
        return ((StringStyleParameter)this.deepestSetParameter("model")).value();
    }

    public void showInStatisticsBox(boolean showInStatisticsBox) {
        ((BooleanStyleParameter)this.parameter("showDataInStatisticsBox")).setValue(showInStatisticsBox);
    }

    public boolean isShownInStatisticsBox() {
        return ((BooleanStyleParameter)this.deepestSetParameter("showDataInStatisticsBox")).value();
    }

    public void showInLegendBox(boolean showInLegendBox) {
        ((BooleanStyleParameter)this.parameter("showDataInLegendBox")).setValue(showInLegendBox);
    }

    public boolean isShownInLegendBox() {
        return ((BooleanStyleParameter)this.deepestSetParameter("showDataInLegendBox")).value();
    }
}

