/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.BusPayload;
import org.lsst.ccs.bus.DestinationsException;
import org.lsst.ccs.utilities.dispatch.CommandFor;
import org.lsst.ccs.utilities.dispatch.ParallelCommandDispatcher;

public class MockBusMessagingLayer
implements BusMessagingLayer {
    private static HashMap<String, AgentBehaviour> agentMap = new HashMap();
    private static BusRegistry busRegistry = new BusRegistry();
    private volatile boolean isClosed = false;
    private static BusMembershipListener[] membershipListeners = new BusMembershipListener[Bus.values().length];
    private static final Object lock = new Object();
    private boolean single;

    public MockBusMessagingLayer() {
    }

    public MockBusMessagingLayer(boolean single) {
        this.single = single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String agentName, Bus ... buses) {
        if (this.isClosed) {
            return;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = lock;
        synchronized (object) {
            AgentBehaviour behaviour = agentMap.get(agentName);
            if (behaviour == null) {
                behaviour = new AgentBehaviour();
                agentMap.put(agentName, behaviour);
            }
            for (Bus bus : buses) {
                int index = bus.ordinal();
                MockBusMessagingLayer.busRegistry.registry[index].add(agentName);
                BusMembershipListener listener = membershipListeners[index];
                if (listener != null) {
                    listener.connecting(agentName, "");
                }
                if (null != behaviour.dispatchers[index]) continue;
                behaviour.dispatchers[index] = new ParallelCommandDispatcher(this.single);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFor(String agentName, Bus ... buses) {
        if (this.isClosed) {
            return;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = lock;
        synchronized (object) {
            AgentBehaviour behaviour = agentMap.get(agentName);
            for (Bus bus : buses) {
                int index = bus.ordinal();
                MockBusMessagingLayer.busRegistry.registry[index].remove(agentName);
                BusMembershipListener listener = membershipListeners[index];
                if (listener != null) {
                    listener.disconnecting(agentName, "");
                }
                if (behaviour == null) continue;
                behaviour.dispatchers[index] = null;
            }
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends BusPayload> void sendMessage(String senderAgent, Bus<T> bus, final T message, String ... destinations) throws IOException {
        if (bus == null) {
            throw new IllegalArgumentException("null bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("null message");
        }
        Object object = lock;
        synchronized (object) {
            ArrayList<String> busAgents = MockBusMessagingLayer.busRegistry.registry[bus.ordinal()];
            if (!busAgents.contains(senderAgent)) {
                throw new IllegalArgumentException("agent " + senderAgent + "not registered on " + bus);
            }
            if (destinations.length == 0 || "".equals(destinations[0]) || "*".equals(destinations[0])) {
                int index = bus.ordinal();
                destinations = MockBusMessagingLayer.busRegistry.registry[index].toArray(destinations);
            } else {
                int length = destinations.length;
                destinations = Arrays.copyOf(destinations, length + 1);
                destinations[length] = "__";
            }
            CommandFor<BusMessageForwarder> cmdMessage = new CommandFor<BusMessageForwarder>(){

                public void invokeOn(BusMessageForwarder instance) {
                    instance.update((BusMessage)message);
                }
            };
            ArrayList<String> failed = new ArrayList<String>();
            for (String destination : destinations) {
                AgentBehaviour behaviour = agentMap.get(destination);
                if (behaviour == null) {
                    if (destination.equals("__")) continue;
                    failed.add(destination);
                    continue;
                }
                int index = bus.ordinal();
                ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                if (dispatcher == null) {
                    failed.add(destination);
                    continue;
                }
                dispatcher.dispatchCommand((CommandFor)cmdMessage);
            }
            if (failed.size() != 0) {
                throw new DestinationsException(failed.toArray());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (forwarder == null) {
            throw new IllegalArgumentException("null forwarder");
        }
        if (this.isClosed) {
            return;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = lock;
        synchronized (object) {
            AgentBehaviour behaviour = agentMap.get(agentName);
            if (behaviour == null) {
                throw new IllegalArgumentException("agent with no registration");
            }
            for (Bus bus : buses) {
                int index = bus.ordinal();
                ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                if (dispatcher == null) {
                    throw new IllegalArgumentException(agentName + " not registered with " + bus);
                }
                dispatcher.addExecutant((Object)forwarder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (forwarder == null) {
            throw new IllegalArgumentException("null forwarder");
        }
        if (this.isClosed) {
            return;
        }
        if (agentName == null || "".equals(agentName)) {
            agentName = "__";
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = lock;
        synchronized (object) {
            AgentBehaviour behaviour = agentMap.get(agentName);
            if (behaviour == null) {
                return;
            }
            for (Bus bus : buses) {
                int index = bus.ordinal();
                ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                if (dispatcher == null) {
                    return;
                }
                dispatcher.removeExecutant((Object)forwarder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMembershipListener(BusMembershipListener listener, Bus ... buses) {
        if (buses == null || buses.length == 0) {
            buses = Bus.values();
        }
        Object object = lock;
        synchronized (object) {
            for (Bus bus : buses) {
                MockBusMessagingLayer.membershipListeners[bus.ordinal()] = listener;
            }
        }
    }

    static class AgentBehaviour {
        ParallelCommandDispatcher[] dispatchers;

        AgentBehaviour() {
            Bus[] buses = Bus.values();
            this.dispatchers = new ParallelCommandDispatcher[buses.length];
        }
    }

    static class BusRegistry {
        ArrayList<String>[] registry;

        BusRegistry() {
            Bus[] buses = Bus.values();
            this.registry = new ArrayList[buses.length];
            for (int ix = 0; ix < this.registry.length; ++ix) {
                this.registry[ix] = new ArrayList();
            }
        }
    }
}

