/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.mock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.MessageFlag;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.DestinationsException;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.mock.CommandFor;
import org.lsst.ccs.messaging.mock.ParallelCommandDispatcher;

class MockBusMessagingLayer
implements BusMessagingLayer {
    private final HashMap<String, AgentBehaviour> agentMap = new HashMap();
    private final BusRegistry busRegistry = new BusRegistry();
    private volatile boolean isClosed = false;
    private final Object lock = new Object();
    private boolean single;

    MockBusMessagingLayer(boolean single) {
        this.single = single;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String agentName, Bus ... buses) throws IOException, DuplicateAgentNameException {
        if (this.isClosed) {
            this.isClosed = false;
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                behaviour = new AgentBehaviour();
                this.agentMap.put(agentName, behaviour);
            }
            for (Bus bus : buses) {
                int index = bus.ordinal();
                if (this.busRegistry.registry[index].contains(agentName)) {
                    throw new DuplicateAgentNameException(agentName, agentName);
                }
                this.busRegistry.registry[index].add(agentName);
                if (null != behaviour.dispatchers[index]) continue;
                behaviour.dispatchers[index] = new ParallelCommandDispatcher(this.single);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRegisteredLocalAgents(Bus ... buses) {
        if (buses == null || buses.length == 0) {
            buses = Bus.values();
        }
        HashSet<String> result = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            for (String agent : this.agentMap.keySet()) {
                for (Bus bus : buses) {
                    int index = bus.ordinal();
                    if (!this.busRegistry.registry[index].contains(agent) || result.contains(agent)) continue;
                    result.add(agent);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFor(String agentName, Bus ... buses) {
        if (this.isClosed) {
            return;
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.remove(agentName);
            for (Bus bus : buses) {
                int index = bus.ordinal();
                this.busRegistry.registry[index].remove(agentName);
                if (behaviour == null) continue;
                behaviour.dispatchers[index] = null;
            }
        }
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends BusMessage> void sendMessage(String senderAgent, Bus bus, T message, MessageFlag ... flags) {
        if (bus == null) {
            throw new IllegalArgumentException("null bus");
        }
        if (message == null) {
            throw new IllegalArgumentException("null message");
        }
        Object object = this.lock;
        synchronized (object) {
            ArrayList<String> busAgents = this.busRegistry.registry[bus.ordinal()];
            if (!busAgents.contains(senderAgent)) {
                throw new IllegalArgumentException("agent " + senderAgent + "not registered on " + bus);
            }
            int index = bus.ordinal();
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(message);
                oos.flush();
                oos.close();
                ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
                ObjectInputStream ois = new ObjectInputStream(in);
                final BusMessage deserializedMessage = (BusMessage)ois.readObject();
                CommandFor<MessagingAccessLayer.BusAccess> cmdMessage = new CommandFor<MessagingAccessLayer.BusAccess>(){

                    @Override
                    public void invokeOn(MessagingAccessLayer.BusAccess instance) {
                        instance.processBusMessage(deserializedMessage);
                    }
                };
                if (message instanceof CommandMessage) {
                    String destination = BusMessagingLayer.parseDestination((String)((CommandMessage)message).getDestination());
                    AgentBehaviour behaviour = this.agentMap.get(destination);
                    if (behaviour == null) {
                        throw new DestinationsException(senderAgent, new Object[]{destination});
                    }
                    ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                    if (dispatcher == null) {
                        throw new DestinationsException(senderAgent, new Object[]{destination});
                    }
                }
                for (String destination : this.busRegistry.registry[index]) {
                    ParallelCommandDispatcher dispatcher;
                    AgentBehaviour behaviour = this.agentMap.get(destination);
                    if (behaviour == null || (dispatcher = behaviour.dispatchers[index]) == null) continue;
                    dispatcher.dispatchCommand(cmdMessage);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (forwarder == null) {
            throw new IllegalArgumentException("null forwarder");
        }
        if (this.isClosed) {
            return;
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                throw new IllegalArgumentException("agent with no registration");
            }
            for (Bus bus : buses) {
                int index = bus.ordinal();
                ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                if (dispatcher == null) {
                    throw new IllegalArgumentException(agentName + " not registered with " + bus);
                }
                dispatcher.addExecutant(forwarder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(String agentName, BusMessageForwarder forwarder, Bus ... buses) {
        if (forwarder == null) {
            throw new IllegalArgumentException("null forwarder");
        }
        if (this.isClosed) {
            return;
        }
        if (buses.length == 0) {
            buses = Bus.values();
        }
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                return;
            }
            for (Bus bus : buses) {
                int index = bus.ordinal();
                ParallelCommandDispatcher dispatcher = behaviour.dispatchers[index];
                if (dispatcher == null) {
                    return;
                }
                dispatcher.removeExecutant(forwarder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MessagingAccessLayer layer) throws DuplicateAgentNameException, IOException {
        if (this.isClosed) {
            this.isClosed = false;
        }
        String agentName = layer.getName();
        Object object = this.lock;
        synchronized (object) {
            AgentBehaviour behaviour = this.agentMap.get(agentName);
            if (behaviour == null) {
                behaviour = new AgentBehaviour();
                this.agentMap.put(agentName, behaviour);
            }
            for (MessagingAccessLayer.BusAccess busAccess : layer.getBusAccesses()) {
                int index = busAccess.getBus().ordinal();
                if (this.busRegistry.registry[index].contains(agentName)) {
                    throw new DuplicateAgentNameException(agentName, agentName);
                }
                this.busRegistry.registry[index].add(agentName);
                if (null != behaviour.dispatchers[index]) continue;
                behaviour.dispatchers[index] = new ParallelCommandDispatcher(this.single);
                behaviour.dispatchers[index].addExecutant(busAccess);
            }
        }
    }

    public void disconnect(MessagingAccessLayer accessLayer) {
        Bus[] buses = new Bus[accessLayer.getBusAccesses().size()];
        for (MessagingAccessLayer.BusAccess busAccess : accessLayer.getBusAccesses()) {
            buses[busAccess.getBus().ordinal()] = busAccess.getBus();
        }
        this.closeFor(accessLayer.getName(), buses);
    }

    private static class BusRegistry {
        ArrayList<String>[] registry;

        BusRegistry() {
            Bus[] buses = Bus.values();
            this.registry = new ArrayList[buses.length];
            for (int ix = 0; ix < this.registry.length; ++ix) {
                this.registry[ix] = new ArrayList();
            }
        }
    }

    private static class AgentBehaviour {
        ParallelCommandDispatcher[] dispatchers;

        AgentBehaviour() {
            Bus[] buses = Bus.values();
            this.dispatchers = new ParallelCommandDispatcher[buses.length];
        }
    }
}

