/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.tests;

import org.lsst.ccs.bus.Bus;
import org.lsst.ccs.bus.BusMembershipListener;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.BusMessageForwarder;
import org.lsst.ccs.bus.BusPayload;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandExecutor;
import org.lsst.ccs.bus.mock.MockBusMessagingLayer;

public class TztMockBus {
    public static void main(String[] args) {
        MockBusMessagingLayer transport = new MockBusMessagingLayer();
        transport.setMembershipListener(new BusMembershipListener(){

            public void connecting(String agentName, String otherInfos) {
                System.out.println(String.valueOf(agentName) + " connecting: " + otherInfos);
            }

            public void disconnecting(String agentName, String otherInfos) {
                System.out.println(String.valueOf(agentName) + " disconnecting: " + otherInfos);
            }

            public void anormalEvent(Exception exc) {
                System.out.println("Exception : " + exc);
            }
        }, new Bus[0]);
        transport.register("SubsysA", new Bus[]{Bus.COMMAND});
        transport.register("SubsysB", new Bus[]{Bus.COMMAND, Bus.STATUS});
        transport.register(null, new Bus[0]);
        System.out.println("--------------------> end registration");
        transport.addMessageListener("SubsysB", (BusMessageForwarder)new Forwarder("SubsysB"), new Bus[]{Bus.COMMAND});
        transport.addMessageListener(null, (BusMessageForwarder)new Forwarder("_snoop_"), new Bus[]{Bus.COMMAND});
        MyCommand command = new MyCommand("one");
        try {
            transport.sendMessage("SubsysA", Bus.COMMAND, (BusPayload)command, new String[]{"SubsysB"});
            command = new MyCommand("two");
            transport.sendMessage("SubsysA", Bus.COMMAND, (BusPayload)command, new String[0]);
            command = new MyCommand("three");
            transport.sendMessage("SubsysA", Bus.COMMAND, (BusPayload)command, new String[]{"SubsysA"});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        transport.closeFor("SubsysB", new Bus[0]);
        command = new MyCommand("four");
        try {
            transport.sendMessage("SubsysA", Bus.COMMAND, (BusPayload)command, new String[0]);
            command = new MyCommand("five");
            transport.register("SubsysB", new Bus[]{Bus.COMMAND, Bus.STATUS});
            transport.addMessageListener("SubsysB", (BusMessageForwarder)new Forwarder("SubsysB2"), new Bus[]{Bus.COMMAND});
            transport.addMessageListener(null, (BusMessageForwarder)new Forwarder("_snoop_2"), new Bus[]{Bus.COMMAND});
            command = new MyCommand("six");
            transport.sendMessage("SubsysA", Bus.COMMAND, (BusPayload)command, new String[]{"SubsysB"});
            transport.closeFor("SubsysB", new Bus[0]);
            transport.addMessageListener("SubsysB", (BusMessageForwarder)new Forwarder("SubsysB3"), new Bus[]{Bus.COMMAND});
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("------> exception: " + e);
        }
    }

    static class Forwarder
    implements BusMessageForwarder {
        String name;

        Forwarder(String name) {
            this.name = name;
        }

        public void update(BusMessage message) {
            System.out.println(String.valueOf(this.name) + " <<< received : " + message);
        }
    }

    static class MyCommand
    extends Command {
        public Object execute(CommandExecutor s) {
            return null;
        }

        public MyCommand(String key) {
            super("", 0, "", null, new Object[0]);
            this.key = key;
        }

        public String toString() {
            return "Command " + this.key;
        }
    }
}

