/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandMessage;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandReply;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.LogMessage;
import org.lsst.ccs.bus.messages.MessageFlag;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.BusMessagePreProcessor;
import org.lsst.ccs.messaging.BusMessagingLayer;
import org.lsst.ccs.messaging.ClusterDeserializationErrorHandler;
import org.lsst.ccs.messaging.CommandExecutor;
import org.lsst.ccs.messaging.CommandMessageListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DefaultClusterMembershipNotifier;
import org.lsst.ccs.messaging.DuplicateAgentNameException;
import org.lsst.ccs.messaging.HasClusterMembershipNotifications;
import org.lsst.ccs.messaging.LogMessageListener;
import org.lsst.ccs.messaging.MessagingAccessLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.messaging.TransportException;
import org.lsst.ccs.messaging.TransportManager;

public class BusApplicationLayer {
    private final AgentInfo agentInfo;
    private final String agentName;
    private final BusMessagingLayer busMessagingLayer;
    private static final org.lsst.ccs.utilities.logging.Logger log = org.lsst.ccs.utilities.logging.Logger.getLogger((String)"org.lsst.ccs.bus.layer");
    private MessagingAccessLayer messagingAccessLayer;
    private final AgentPresenceManager agentPresenceManager;
    private final ForwarderToCommandExecutor commandExecutorForwarder = new ForwarderToCommandExecutor();
    private final ForwarderToCommandOriginator commandOriginatorForwarder = new ForwarderToCommandOriginator();
    private ClusterDeserializationErrorHandler cdeh = ClusterDeserializationErrorHandler.DEFAULT;
    private final HasClusterMembershipNotifications disconnectionNotificationProvider;
    private final MessagingAccessLayer.BusAccess<LogMessage> logBusAccess;
    private final MessagingAccessLayer.BusAccess<StatusMessage> statusBusAccess;
    private final MessagingAccessLayer.BusAccess<CommandMessage> commandBusAccess;
    private static final Logger LOG = Logger.getLogger(BusApplicationLayer.class.getName());

    BusApplicationLayer(AgentInfo agentInfo, AgentMessagingLayer agentMessagingLayer) {
        this.agentInfo = agentInfo;
        this.agentName = agentInfo.getName();
        this.agentPresenceManager = new AgentPresenceManager(agentInfo, agentMessagingLayer);
        String protocolProperty = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.transport", "jgroups:udp_ccs:");
        try {
            this.busMessagingLayer = TransportManager.getConnection(protocolProperty);
            this.disconnectionNotificationProvider = this.busMessagingLayer instanceof HasClusterMembershipNotifications ? (HasClusterMembershipNotifications)((Object)this.busMessagingLayer) : new DefaultClusterMembershipNotifier(this.agentName);
        }
        catch (TransportException exc) {
            throw new RuntimeException(exc);
        }
        this.disconnectionNotificationProvider.addClusterMembershipListener(this.agentPresenceManager);
        this.logBusAccess = new MessagingAccessLayer.BusAccess(Bus.LOG);
        this.statusBusAccess = new MessagingAccessLayer.BusAccess<StatusMessage>(Bus.STATUS){

            @Override
            public void processClusterDeserializationError(String address, RuntimeException e) {
                BusApplicationLayer.this.cdeh.process(address, e);
            }
        };
        this.commandBusAccess = new MessagingAccessLayer.BusAccess<CommandMessage>(Bus.COMMAND){

            @Override
            public void processBusMessage(CommandMessage message) {
                super.processBusMessage(message);
                if (message instanceof CommandRequest) {
                    BusApplicationLayer.this.commandExecutorForwarder.update((CommandRequest)message);
                } else if (message instanceof CommandReply) {
                    BusApplicationLayer.this.commandOriginatorForwarder.update((CommandReply)message);
                }
            }
        };
        this.messagingAccessLayer = new MessagingAccessLayer(agentInfo, this.logBusAccess, this.statusBusAccess, this.commandBusAccess);
        this.addStatusListener(this.agentPresenceManager, BusMessageFilterFactory.messageOrigin(this.agentName).negate());
        if (this.disconnectionNotificationProvider instanceof StatusMessageListener) {
            this.addStatusListener((StatusMessageListener)((Object)this.disconnectionNotificationProvider), BusMessageFilterFactory.messageOrigin(this.agentName).negate());
        }
    }

    final boolean hasInternalHeartbeat() {
        return this.disconnectionNotificationProvider.hasInternalHeartbeat();
    }

    final void addBusMessagePreProcessor(BusMessagePreProcessor preProcessor) {
        this.messagingAccessLayer.addBusMessagePreProcessor(preProcessor);
    }

    final BusMessagingLayer getBusMessagingLayer() {
        return this.busMessagingLayer;
    }

    public final MessagingAccessLayer getMessagingAccessLayer() {
        return this.messagingAccessLayer;
    }

    final void connectToBuses() {
        String groupNameFilter = this.agentInfo.getAgentProperty("group");
        if (groupNameFilter != null) {
            Predicate<BusMessage<? extends Serializable, ?>> groupFilter = bm -> {
                String group = bm.getOriginAgentInfo().getAgentProperty("group");
                if (group == null) {
                    return true;
                }
                return group.equals(groupNameFilter);
            };
            this.logBusAccess.addBusMessageFilter(groupFilter);
            this.statusBusAccess.addBusMessageFilter(groupFilter);
            this.commandBusAccess.addBusMessageFilter(groupFilter);
        }
        try {
            this.busMessagingLayer.connect(this.messagingAccessLayer);
        }
        catch (IOException | DuplicateAgentNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    void sendCommand(CommandRequest cmd, CommandOriginator originator) {
        String destination = BusMessagingLayer.parseDestination(cmd.getDestination());
        if (destination == null || destination.isEmpty()) {
            throw new RuntimeException("Invalid destination for command " + cmd);
        }
        this.commandOriginatorForwarder.addCommandOriginator(cmd.getCorrelationId(), originator);
        if (cmd.getOriginAgentInfo().getName() == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.agentName, Bus.COMMAND, cmd, new MessageFlag[0]);
    }

    void sendStatus(StatusMessage status, MessageFlag ... flags) {
        String origin = status.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.agentName, Bus.STATUS, status, flags);
    }

    void sendLog(LogMessage evt, MessageFlag ... flags) {
        String origin = evt.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.agentName, Bus.LOG, evt, flags);
    }

    void reply(CommandReply cmd) {
        String origin = cmd.getOriginAgentInfo().getName();
        if (origin == null) {
            throw new RuntimeException("Agent name must not be null");
        }
        this.busMessagingLayer.sendMessage(this.agentName, Bus.COMMAND, cmd, new MessageFlag[0]);
    }

    void setCommandExecutor(CommandExecutor executor) {
        this.commandExecutorForwarder.setCommandExecutor(executor);
    }

    void addCommandListener(CommandMessageListener l, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        ForwarderToCommandListeners forwarder = new ForwarderToCommandListeners(l, filter);
        this.messagingAccessLayer.getBusAccess(Bus.COMMAND).addForwarder(l, forwarder);
    }

    void removeCommandListener(CommandMessageListener l) {
        this.messagingAccessLayer.getBusAccess(Bus.COMMAND).removeForwarder(l);
    }

    void addStatusListener(StatusMessageListener l, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        ForwarderToStatusListeners forwarder = new ForwarderToStatusListeners(l, filter);
        this.messagingAccessLayer.getBusAccess(Bus.STATUS).addForwarder(l, forwarder);
    }

    void removeStatusListener(StatusMessageListener l) {
        this.messagingAccessLayer.getBusAccess(Bus.STATUS).removeForwarder(l);
    }

    void addLogListener(LogMessageListener l, Predicate<BusMessage<? extends Serializable, ?>> filter) {
        ForwarderToLogListeners forwarder = new ForwarderToLogListeners(l, filter);
        this.messagingAccessLayer.getBusAccess(Bus.LOG).addForwarder(l, forwarder);
    }

    void removeLogListener(LogMessageListener l) {
        this.messagingAccessLayer.getBusAccess(Bus.LOG).removeForwarder(l);
    }

    void setClusterDeserializationErrorHandler(ClusterDeserializationErrorHandler h) {
        this.cdeh = h;
    }

    void close() {
        if (this.disconnectionNotificationProvider instanceof StatusMessageListener) {
            this.removeStatusListener((StatusMessageListener)((Object)this.disconnectionNotificationProvider));
        }
        this.disconnectionNotificationProvider.removeClusterMembershipListener(this.agentPresenceManager);
        this.disconnectionNotificationProvider.clear();
        this.removeStatusListener(this.agentPresenceManager);
        this.agentPresenceManager.disconnect();
        this.busMessagingLayer.disconnect(this.messagingAccessLayer);
    }

    public AgentPresenceManager getAgentPresenceManager() {
        return this.agentPresenceManager;
    }

    class ForwarderToCommandExecutor
    implements BusMessageForwarder<CommandRequest> {
        private volatile CommandExecutor commandExecutor;

        ForwarderToCommandExecutor() {
        }

        void setCommandExecutor(CommandExecutor commandExecutor) {
            if (this.commandExecutor != null) {
                throw new RuntimeException("A CommandExecutor is already registered for this Agent. There can be only one!");
            }
            this.commandExecutor = commandExecutor;
        }

        @Override
        public void update(CommandRequest message) {
            String destination = message.getDestination();
            if (destination.contains("/")) {
                destination = destination.substring(0, destination.indexOf("/"));
            }
            if (!destination.equals(BusApplicationLayer.this.agentName)) {
                return;
            }
            if (this.commandExecutor == null) {
                throw new RuntimeException("A CommandExecutor has not been registered for this Agent.");
            }
            try {
                this.commandExecutor.executeCommandRequest(message);
            }
            catch (Exception throwable) {
                throwable.printStackTrace();
                log.error((Object)("on command :" + throwable));
            }
        }
    }

    class ForwarderToCommandOriginator
    implements BusMessageForwarder<CommandReply> {
        private final ConcurrentHashMap<UUID, RequestData> currentRequests = new ConcurrentHashMap();

        ForwarderToCommandOriginator() {
        }

        void addCommandOriginator(UUID originatorId, CommandOriginator originator) {
            this.currentRequests.put(originatorId, new RequestData(originator));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(CommandReply message) {
            String destination = message.getDestination();
            if (!destination.equals(BusApplicationLayer.this.agentName)) {
                return;
            }
            UUID originatorId = message.getCorrelationId();
            ForwarderToCommandOriginator forwarderToCommandOriginator = this;
            synchronized (forwarderToCommandOriginator) {
                RequestData reqData = this.currentRequests.get(originatorId);
                if (reqData == null) {
                    throw new RuntimeException("Could not find the originator of the CommandRequest " + message.getEncodedData());
                }
                if (message instanceof CommandAck) {
                    reqData.originator.processAck((CommandAck)message);
                    if (reqData.result == null) {
                        reqData.ackReceived = true;
                    } else {
                        reqData.originator.processResult(reqData.result);
                        this.currentRequests.remove(originatorId);
                    }
                } else if (message instanceof CommandNack) {
                    reqData.originator.processNack((CommandNack)message);
                    this.currentRequests.remove(originatorId);
                } else if (message instanceof CommandResult) {
                    if (reqData.ackReceived) {
                        reqData.originator.processResult((CommandResult)message);
                        this.currentRequests.remove(originatorId);
                    } else {
                        reqData.result = (CommandResult)message;
                    }
                }
            }
        }

        private class RequestData {
            CommandOriginator originator;
            CommandResult result;
            boolean ackReceived;

            RequestData(CommandOriginator originator) {
                this.originator = originator;
            }
        }
    }

    private class ForwarderToCommandListeners
    implements BusMessageForwarder<CommandMessage> {
        private final CommandMessageListener listener;
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;

        ForwarderToCommandListeners(CommandMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(CommandMessage message) {
            if (this.filter == null || this.filter.test((BusMessage<Serializable, ?>)message)) {
                this.listener.onCommandMessage(message);
            }
        }
    }

    private class ForwarderToStatusListeners
    implements BusMessageForwarder<StatusMessage> {
        private final StatusMessageListener listener;
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;
        private final long infoLevel = Long.parseLong(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.messaging.info.level", "25"));
        private final long warningLevel = Long.parseLong(BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.messaging.warning.level", "100"));

        ForwarderToStatusListeners(StatusMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(StatusMessage message) {
            if (this.filter == null || this.filter.test((BusMessage<Serializable, ?>)message)) {
                long start = System.currentTimeMillis();
                this.listener.onStatusMessage(message);
                long delta = System.currentTimeMillis() - start;
                LOG.log(this.getLogLevelForDelay(delta), "Processing of message {0} by listener {1} took {2} ms", new Object[]{message.getClass().getCanonicalName(), this.listener, delta});
            }
        }

        private Level getLogLevelForDelay(long delay) {
            if (delay < this.infoLevel) {
                return Level.FINE;
            }
            if (delay < this.warningLevel) {
                return Level.INFO;
            }
            return Level.WARNING;
        }
    }

    private class ForwarderToLogListeners
    implements BusMessageForwarder<LogMessage> {
        private final LogMessageListener listener;
        private final Predicate<BusMessage<? extends Serializable, ?>> filter;

        ForwarderToLogListeners(LogMessageListener listener, Predicate<BusMessage<? extends Serializable, ?>> filter) {
            this.listener = listener;
            this.filter = filter;
        }

        @Override
        public void update(LogMessage message) {
            if (this.filter == null || this.filter.test((BusMessage<Serializable, ?>)message)) {
                this.listener.onLogMessage(message);
            }
        }
    }
}

