/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.TransportStateException;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.messaging.util.LegacyDispatcher;
import org.lsst.ccs.messaging.util.MultiQueueDispatcher;

public class DispatcherTest {
    final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    final int N_TASKS = 1;
    final int MAX_TASK_DURATION = 200;
    final int N_AGENTS = 5;
    final int NB = 2 * Bus.values().length * Dispatcher.Order.values().length;
    final Object[] locks = new Object[this.NB];
    final int[] submitted = new int[this.NB];
    final int[] executed = new int[this.NB];
    final EnumMap<Bus, int[]> lastExecutedPerAgent = new EnumMap(Bus.class);
    private volatile Dispatcher dispatcher;

    Random rand() {
        return this.random.get();
    }

    public DispatcherTest() {
        for (int i = 0; i < this.NB; ++i) {
            this.locks[i] = new Object();
        }
    }

    @Test
    public void test() {
        Dispatcher[] dd;
        for (Dispatcher d : dd = new Dispatcher[]{new LegacyDispatcher(""), new MultiQueueDispatcher("")}) {
            System.out.println("Starting test() " + d.getClass().getSimpleName());
            this.dispatcher = d;
            this.clear(0);
            this.dispatcher.initialize();
            for (int i = 0; i < 1; ++i) {
                this.startTask();
            }
            if (this.dispatcher instanceof MultiQueueDispatcher) {
                ((MultiQueueDispatcher)this.dispatcher).shutdown();
            } else {
                this.dispatcher.shutdown();
            }
            Assert.assertArrayEquals((String)"Descrepancy between numbers of started and finished tasks", (int[])this.submitted, (int[])this.executed);
            System.out.println("End test() " + this.dispatcher.getClass().getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(int lockIndex) {
        if (lockIndex < this.NB) {
            Object object = this.locks[lockIndex];
            synchronized (object) {
                this.clear(lockIndex + 1);
            }
        } else {
            Arrays.fill(this.submitted, 0);
            Arrays.fill(this.executed, 0);
            for (Bus bus : Bus.values()) {
                this.lastExecutedPerAgent.put(bus, new int[5]);
            }
        }
    }

    private void startTask() {
        int index = this.rand().nextInt(this.NB);
        boolean in = this.getIn(index);
        Bus bus = this.getBus(index);
        Dispatcher.Order order = this.getOrder(index);
        int[] agents = new int[]{};
        if (in && order == Dispatcher.Order.NORM) {
            int n = this.rand().nextInt(6);
            if (n == 5) {
                int i;
                ArrayList<Integer> all = new ArrayList<Integer>(5);
                for (i = 0; i < 5; ++i) {
                    all.add(i);
                }
                Collections.shuffle(all, this.rand());
                n = this.rand().nextInt(5);
                agents = new int[n];
                for (i = 0; i < n; ++i) {
                    agents[i] = (Integer)all.get(i);
                }
            } else {
                agents = new int[]{n};
            }
        }
        String[] agentNames = new String[agents.length];
        for (int i = 0; i < agents.length; ++i) {
            agentNames[i] = Integer.toString(agents[i]);
        }
        int n = index;
        int n2 = this.submitted[n] + 1;
        this.submitted[n] = n2;
        TestTask task = new TestTask(n2, index, agents);
        if (in) {
            this.dispatcher.in(null, 0L, (Runnable)task, bus, agentNames);
        } else {
            this.dispatcher.out(null, 0L, (Runnable)task, bus, order);
        }
    }

    @Test
    public void testListeners() {
        Dispatcher[] dd;
        for (Dispatcher d : dd = new Dispatcher[]{new LegacyDispatcher(""), new MultiQueueDispatcher("")}) {
            System.out.println("Starting testListeners() " + d.getClass().getSimpleName());
            d.initialize();
            AtomicInteger completed = new AtomicInteger(0);
            d.addListener(e -> completed.incrementAndGet());
            d.addTaskListener((task, stage) -> {
                TestListenersTask tlt = (TestListenersTask)task.getPayload();
                tlt.stageEnded(stage);
            });
            for (int i = 0; i < 1; ++i) {
                d.in(null, 0L, (Runnable)new TestListenersTask(d), Bus.STATUS, new String[]{"agentName"});
                d.out(null, 0L, (Runnable)new TestListenersTask(d), Bus.LOG, Dispatcher.Order.NORM);
            }
            d.shutdown();
            Assert.assertEquals((String)"Executed callbecks", (long)2L, (long)completed.get());
            System.out.println("End testListeners() " + d.getClass().getSimpleName());
        }
    }

    @Test
    public void testAlerts() {
        Dispatcher[] dd;
        for (Dispatcher d : dd = new Dispatcher[]{new LegacyDispatcher(""), new MultiQueueDispatcher("")}) {
            System.out.println("Starting testAlerts() " + d.getClass().getSimpleName());
            d.initialize();
            StringBuffer sb = new StringBuffer();
            d.addListener(e -> {
                if (e instanceof Dispatcher.AlertEvent) {
                    sb.append(" ");
                    Dispatcher.AlertEvent ae = (Dispatcher.AlertEvent)e;
                    sb.append(ae.getAlert().getAlertId()).append(":");
                    sb.append(ae.getAlert().getDescription()).append(":");
                    sb.append(ae.getCause()).append(":");
                    sb.append(ae.getSeverity()).append(":");
                    sb.append(String.join((CharSequence)".", ae.getAlert().getAlertDataNames()));
                }
            });
            d.registerAlert(new Alert("1", "d1"));
            d.raiseAlert("1", AlertState.WARNING, "c1");
            d.raiseAlert("2", AlertState.WARNING, "c2");
            d.raiseAlert(new Alert("1", "d2"), AlertState.NOMINAL, "c3");
            Alert a = new Alert("2", "d3");
            a.addAlertData("k2", (Serializable)((Object)"v2"));
            d.raiseAlert(a, AlertState.ALARM, "c4");
            d.shutdown();
            Assert.assertEquals((String)"Alerts", (Object)" 1:d1:c1:WARNING: 1:d2:c3:NOMINAL: 2:d3:c4:ALARM:k2", (Object)sb.toString());
            System.out.println("End testListeners() " + d.getClass().getSimpleName());
        }
    }

    @Test
    public void testInitialize() {
        Dispatcher[] dd;
        for (Dispatcher d : dd = new Dispatcher[]{new LegacyDispatcher(""), new MultiQueueDispatcher("")}) {
            System.out.println("Starting testInitialize() " + d.getClass().getSimpleName());
            try {
                d.out(null, 0L, () -> {}, Bus.LOG, Dispatcher.Order.NORM);
                Assert.fail((String)"TransportStateException not thrown.");
            }
            catch (TransportStateException transportStateException) {
                // empty catch block
            }
            try {
                d.in(null, 0L, () -> {}, Bus.LOG, new String[]{"test"});
            }
            catch (Exception x) {
                Assert.fail((String)("Unexpected exception: " + x));
            }
            d.shutdown();
            System.out.println("Finished testInitialize() " + d.getClass().getSimpleName());
        }
    }

    boolean getIn(int index) {
        return index < this.NB / 2;
    }

    Bus getBus(int index) {
        index %= this.NB / 2;
        return Bus.values()[index /= Dispatcher.Order.values().length];
    }

    Dispatcher.Order getOrder(int index) {
        index %= this.NB / 2;
        return Dispatcher.Order.values()[index %= Dispatcher.Order.values().length];
    }

    class TestTask
    implements Runnable {
        final int id;
        final int index;
        final int[] agents;

        TestTask(int id, int index, int[] agents) {
            this.id = id;
            this.index = index;
            this.agents = agents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int wait = DispatcherTest.this.rand().nextInt(200);
            if (wait > 100) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean in = DispatcherTest.this.getIn(this.index);
            Bus bus = DispatcherTest.this.getBus(this.index);
            Dispatcher.Order order = DispatcherTest.this.getOrder(this.index);
            Object object = DispatcherTest.this.locks[this.index];
            synchronized (object) {
                int n = this.index;
                DispatcherTest.this.executed[n] = DispatcherTest.this.executed[n] + 1;
                if (order == Dispatcher.Order.NORM) {
                    int[] ra = DispatcherTest.this.lastExecutedPerAgent.get(bus);
                    for (int agent : this.agents) {
                        Assert.assertTrue((String)("Out of order: " + in + " " + bus + " " + agent), (ra[agent] < this.id ? 1 : 0) != 0);
                        ra[agent] = this.id;
                    }
                }
            }
            wait = DispatcherTest.this.rand().nextInt(200);
            if (wait > 100) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    static class TestListenersTask
    implements Runnable {
        static int FULL = (1 << Dispatcher.Stage.values().length) - 1;
        private final Dispatcher disp;
        private int mask;

        TestListenersTask(Dispatcher dispatcher) {
            this.disp = dispatcher;
        }

        public synchronized void stageEnded(Dispatcher.Stage stage) {
            this.mask ^= 1 << stage.ordinal();
            if (this.mask == FULL) {
                this.disp.fireEvent(new Dispatcher.Event(this.disp));
            }
        }

        @Override
        public synchronized void run() {
            Assert.assertEquals((String)"Before RUN stage ", (long)0L, (long)(this.mask & 1 << Dispatcher.Stage.RUN.ordinal()));
            Assert.assertNotEquals((String)"After START stage ", (long)0L, (long)(this.mask & 1 << Dispatcher.Stage.START.ordinal()));
            Assert.assertNotEquals((String)"After WAIT stage ", (long)0L, (long)(this.mask & 1 << Dispatcher.Stage.WAIT.ordinal()));
        }
    }
}

