/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;

public class AgentPresenceManagerTest {
    @BeforeAll
    public static void setUpClass() {
    }

    @AfterAll
    public static void tearDownClass() {
    }

    @BeforeEach
    public void setUp() {
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void testListConnectedAgents() {
        AgentInfo a0 = new AgentInfo("0", AgentInfo.AgentType.MMM);
        AgentPresenceManager apm = new AgentPresenceManager(a0, (AgentMessagingLayer)new TestMessagingLayer(a0));
        Listener listener = new Listener();
        apm.addAgentPresenceListener((AgentPresenceListener)listener);
        AgentInfo a1 = new AgentInfo("1", AgentInfo.AgentType.WORKER);
        AgentInfo a2 = new AgentInfo("2", AgentInfo.AgentType.WORKER);
        AgentInfo a3 = new AgentInfo("3", AgentInfo.AgentType.WORKER);
        StateBundle stateOff = new StateBundle(new Enum[]{PhaseState.OFF_LINE});
        StateBundle stateInit = new StateBundle(new Enum[]{PhaseState.INITIALIZING});
        StateBundle stateOp = new StateBundle(new Enum[]{PhaseState.OPERATIONAL});
        StateBundle stateClos = new StateBundle(new Enum[]{PhaseState.CLOSING});
        StatusHeartBeat m1op = new StatusHeartBeat(0);
        m1op.setState(stateOp);
        m1op.setOriginAgentInfo(a1);
        StatusHeartBeat m2op = new StatusHeartBeat(0);
        m2op.setState(stateOp);
        m2op.setOriginAgentInfo(a2);
        StatusHeartBeat m3op = new StatusHeartBeat(0);
        m3op.setState(stateOp);
        m3op.setOriginAgentInfo(a3);
        Assert.assertEquals(new HashSet(), new HashSet(apm.listConnectedAgents()));
        apm.membersJoined(List.of(a1.getName(), "2"), false);
        apm.onStatusMessage((StatusMessage)m1op);
        apm.onStatusMessage((StatusMessage)m2op);
        apm.membersLeft(List.of(a1.getName(), a2.getName()));
        apm.onStatusMessage((StatusMessage)m1op);
        apm.onStatusMessage((StatusMessage)m2op);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals(Set.of(a1, a2), new HashSet(apm.listConnectedAgents()));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Connections" + listener);
        Assert.assertEquals((Object)"", (Object)listener.getError());
    }

    @Test
    public void testDiscardedMessages() {
        AgentInfo a0 = new AgentInfo("0", AgentInfo.AgentType.MMM);
        AgentPresenceManager apm = new AgentPresenceManager(a0, (AgentMessagingLayer)new TestMessagingLayer(a0));
        Listener listener = new Listener();
        apm.addAgentPresenceListener((AgentPresenceListener)listener);
        AgentInfo a1 = new AgentInfo("1", AgentInfo.AgentType.WORKER);
        AgentInfo a2 = new AgentInfo("2", AgentInfo.AgentType.WORKER);
        AgentInfo a3 = new AgentInfo("3", AgentInfo.AgentType.WORKER);
        StateBundle stateOff = new StateBundle(new Enum[]{PhaseState.OFF_LINE});
        StateBundle stateInit = new StateBundle(new Enum[]{PhaseState.INITIALIZING});
        StateBundle stateOp = new StateBundle(new Enum[]{PhaseState.OPERATIONAL});
        StateBundle stateClos = new StateBundle(new Enum[]{PhaseState.CLOSING});
        StatusHeartBeat m1op = new StatusHeartBeat(0);
        m1op.setState(stateOp);
        m1op.setOriginAgentInfo(a1);
        StatusHeartBeat m2op = new StatusHeartBeat(0);
        m2op.setState(stateOp);
        m2op.setOriginAgentInfo(a2);
        StatusHeartBeat m3op = new StatusHeartBeat(0);
        m3op.setState(stateOp);
        m3op.setOriginAgentInfo(a3);
        Assert.assertEquals(new HashSet(), new HashSet(apm.listConnectedAgents()));
        apm.membersJoined(List.of("ABCDEF"), false);
        for (int i = 0; i < 10; ++i) {
            apm.onStatusMessage((StatusMessage)m1op);
            apm.onStatusMessage((StatusMessage)m2op);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        apm.onStatusMessage((StatusMessage)m1op);
        apm.onStatusMessage((StatusMessage)m2op);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals(Set.of(a1, a2), new HashSet(apm.listConnectedAgents()));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Connections" + listener);
        Assert.assertEquals((Object)"", (Object)listener.getError());
    }

    private class TestMessagingLayer
    extends AgentMessagingLayer {
        TestMessagingLayer(AgentInfo agentInfo) {
            super(agentInfo);
        }

        public void waitForMessageLayerConnection() {
        }
    }

    private static class Listener
    implements AgentPresenceListener {
        final StringBuilder sb = new StringBuilder();
        final Set<AgentInfo> stat = new HashSet<AgentInfo>();
        final StringBuilder error = new StringBuilder();

        private Listener() {
        }

        public synchronized void connecting(AgentInfo ... agents) {
        }

        public synchronized void disconnected(AgentInfo ... agents) {
            if (agents.length > 0) {
                this.sb.append(":");
                for (AgentInfo a : agents) {
                    this.sb.append("-").append(a.getName());
                    if (this.stat.remove(a)) continue;
                    this.error.append("Orphaned disconnection notification for ").append(a.getName()).append(". ");
                }
            }
        }

        public synchronized void connected(AgentInfo ... agents) {
            if (agents.length > 0) {
                this.sb.append(":");
                for (AgentInfo a : agents) {
                    this.sb.append("+").append(a.getName());
                    if (this.stat.add(a)) continue;
                    this.error.append("Double connection notification for ").append(a.getName()).append(".");
                }
            }
        }

        public synchronized String toString() {
            return this.sb.toString();
        }

        public synchronized String getError() {
            return this.error.toString();
        }
    }
}

