package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.data.AgentLock;

/**
 * Interface for finding lock and level for an agent at the AgentMessagingLayer.
 * 
 * @author LSST CCS Team
 */
public interface LockLevelService {
          
    /**
     * Get this agent's operational level for the given subsystem.
     * @param agentName
     * @return a level
     */
    public int getLevelForAgent(String agentName);
     
    /**
     * Get this agent's lock, if available.
     * @param agentName The agent name.
     * @return The AgentLock held on the agent, if available. Otherwise null is
     *         returned.
     */
    public AgentLock getLockForAgent(String agentName);
    
    /**
     * Returns the current user.
     * @return User ID.
     */
    public String getUserId();
     
}
