/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.messaging.util.MultiQueueDispatcher;

public class MultiQueueDispatcherTest {
    @Test
    public void testShutdown() {
    }

    @Test
    public void testIn() {
        System.out.println("Starting testIn()...");
        System.gc();
        long time = System.currentTimeMillis();
        MultiQueueDispatcher instance = new MultiQueueDispatcher("inThreads=1,1,8&queue/in/STATUS=10,10,20");
        instance.initialize();
        TestListener listener = new TestListener();
        instance.addListener((Dispatcher.Listener)listener);
        AtomicInteger count = new AtomicInteger(0);
        for (int i = 0; i < 25; ++i) {
            long delay;
            if (i == 2) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            switch (i) {
                case 0: {
                    delay = 2000L;
                    break;
                }
                case 1: {
                    delay = 3000L;
                    break;
                }
                default: {
                    delay = 0L;
                }
            }
            TestTask task = new TestTask(delay, count);
            instance.in(null, 0L, (Runnable)task, Bus.STATUS, new String[]{String.valueOf(i % 2)});
        }
        instance.shutdown();
        Assert.assertEquals((String)"Wrong count of tasks by the end of shutdown", (long)25L, (long)count.get());
        time = (System.currentTimeMillis() - time) / 1000L;
        Assert.assertEquals((String)"Wrong shutdown time for in()", (long)3L, (long)time);
        Assert.assertEquals((String)"Received alerts", (Object)"/SW/SW/SA/SW/SN", (Object)listener.getAndClear());
        System.out.println("Finished testIn()");
    }

    @Test
    public void testOut() {
        System.out.println("Starting testOut()...");
        System.gc();
        long time = System.currentTimeMillis();
        MultiQueueDispatcher instance = new MultiQueueDispatcher("duration/out/LOG/START=2000,2000,5500&duration/out/LOG/WAIT=2500,2500&duration/out/LOG/RUN=700,700&duration/out/LOG/SUBMIT=700,700");
        instance.initialize();
        TestListener listener = new TestListener();
        instance.addListener((Dispatcher.Listener)listener);
        AtomicInteger count = new AtomicInteger(0);
        for (int i = 0; i < 10; ++i) {
            long refTime;
            switch (i) {
                case 1: 
                case 2: 
                case 5: {
                    refTime = System.currentTimeMillis() - 5000L;
                    break;
                }
                case 6: {
                    refTime = System.currentTimeMillis() - 6000L;
                    break;
                }
                default: {
                    refTime = System.currentTimeMillis();
                }
            }
            long duration = i > 3 && i < 8 ? 1000L : 0L;
            TestTask task = new TestTask(duration, count);
            instance.out(null, refTime, (Runnable)task, Bus.LOG, Dispatcher.Order.NORM);
        }
        instance.shutdown();
        Assert.assertEquals((String)"Wrong count of tasks by the end of shutdown", (long)10L, (long)count.get());
        time = (System.currentTimeMillis() - time) / 1000L;
        Assert.assertEquals((String)"Wrong shutdown time for in()", (long)4L, (long)time);
        Assert.assertEquals((String)"Received alerts", (Object)"/SW/SN/SW/SA/SN/RW/WW/RN", (Object)listener.getAndClear());
        System.out.println("Finished testOut()");
    }

    private static /* synthetic */ void lambda$testShutdown$2(AtomicInteger count) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        count.getAndIncrement();
    }

    private static /* synthetic */ void lambda$testShutdown$1(Random rand, AtomicInteger delayed, AtomicInteger count) {
        if (rand.nextInt(100) == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            delayed.getAndIncrement();
        }
        count.getAndIncrement();
    }

    private static /* synthetic */ void lambda$testShutdown$0(Random rand, AtomicInteger delayed, AtomicInteger count) {
        if (rand.nextInt(100) == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            delayed.getAndIncrement();
        }
        count.getAndIncrement();
    }

    private static class TestListener
    implements Dispatcher.Listener {
        private final StringBuilder sb = new StringBuilder();

        private TestListener() {
        }

        public void onEvent(Dispatcher.Event event) {
            try {
                Dispatcher.AlertEvent e = (Dispatcher.AlertEvent)event;
                String id = e.getAlert().getAlertId();
                int i = id.lastIndexOf(47);
                id = id.substring(i, i + 2);
                this.sb.append(id).append(e.getSeverity().name().charAt(0));
            }
            catch (ClassCastException x) {
                Assert.fail((String)("Event of unexpected type " + event.getClass().getCanonicalName()));
            }
        }

        String getAndClear() {
            String out = this.sb.toString();
            this.sb.delete(0, this.sb.length());
            return out;
        }
    }

    private static class TestTask
    implements Runnable {
        private final long duration;
        private final AtomicInteger count;

        TestTask(long duration, AtomicInteger count) {
            this.duration = duration;
            this.count = count;
        }

        @Override
        public void run() {
            if (this.duration > 0L) {
                try {
                    Thread.sleep(this.duration);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.count != null) {
                this.count.getAndIncrement();
            }
        }
    }
}

