/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentPropertyPredicate;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ClusterMembershipListener;
import org.lsst.ccs.messaging.StatusMessageListener;

public class AgentPresenceManager
implements StatusMessageListener,
ClusterMembershipListener {
    private final Object agentsLock = new Object();
    final CopyOnWriteArrayList<AgentPresenceListener> listAPL = new CopyOnWriteArrayList();
    private final Map<AgentInfo, AgentPresenceState> mapAgents = new ConcurrentHashMap<AgentInfo, AgentPresenceState>();
    private final Set<AgentInfo> fullyConnectedAgents = new CopyOnWriteArraySet<AgentInfo>();
    private static final Logger LOG = Logger.getLogger(AgentPresenceManager.class.getName());
    private final ReentrantLock agentConnectionWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, AgentPropertyPredicate> agentConnectionWaitList;
    private final ReentrantLock agentDisconnectionWaitLock = new ReentrantLock(true);
    private volatile LinkedHashMap<Condition, String> agentDisconnectionWaitList;
    private final Future checkQueueFuture;
    private final AgentMessagingLayer agentMessagingLayer;
    private final AgentInfo thisAgentInfo;
    private final BlockingQueue<Runnable> notifications = new ArrayBlockingQueue<Runnable>(500);
    private final AtomicBoolean firstConnection = new AtomicBoolean(false);
    private final List<DelayedConnectedNotification> delayedNotifications = new CopyOnWriteArrayList<DelayedConnectedNotification>();

    public AgentPresenceManager(AgentInfo agentInfo, AgentMessagingLayer agentMessagingLayer) {
        ExecutorService queueExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "Connection/Disconnection queue");
            t.setDaemon(true);
            return t;
        });
        this.checkQueueFuture = queueExecutor.submit(() -> this.checkQueue());
        this.agentMessagingLayer = agentMessagingLayer;
        this.thisAgentInfo = agentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.agentsLock;
        synchronized (object) {
            this.checkQueueFuture.cancel(true);
            this.notifications.clear();
            this.mapAgents.clear();
            this.fullyConnectedAgents.clear();
        }
    }

    private void checkQueue() {
        try {
            while (true) {
                this.notifications.take().run();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed when draining Connection/Disconnection queue.", e);
        }
    }

    @Override
    public void onStatusMessage(StatusMessage s) {
        AgentInfo a = s.getOriginAgentInfo();
        if (a == null) {
            return;
        }
        PhaseState ps = (PhaseState)s.getState().getState(PhaseState.class);
        if (ps == null) {
            new RuntimeException().printStackTrace();
            LOG.log(Level.WARNING, "No PhaseState while processing message {0} with state {1}", new Object[]{s, s.getState()});
            return;
        }
        switch (ps) {
            case OFF_LINE: {
                this.disconnectedAgent(a);
                break;
            }
            case INITIALIZING: {
                this.updateAgent(a, AgentPresenceState.CONNECTING);
                break;
            }
            default: {
                this.updateAgent(a, AgentPresenceState.CONNECTED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAgent(AgentInfo a, AgentPresenceState state) {
        LOG.log(Level.FINEST, "Updating {0} for AP State {1}: exists? {2} ({3})", new Object[]{a.getName(), state, this.mapAgents.containsKey(a), this.mapAgents.get(a)});
        Object object = this.agentsLock;
        synchronized (object) {
            AgentPresenceState oldState = this.mapAgents.get(a);
            if (oldState != null) {
                if (oldState != state) {
                    if (state != AgentPresenceState.CONNECTED) {
                        throw new RuntimeException(this.thisAgentInfo.getName() + " Something went really wrong with this agent's state: " + a.getName() + " new state: " + (Object)((Object)state) + " old state: " + (Object)((Object)oldState));
                    }
                    this.mapAgents.put(a, AgentPresenceState.CONNECTED);
                    this.processConnectionDisconnectionEvent(AgentPresenceState.CONNECTED, a);
                }
            } else {
                this.mapAgents.put(a, state);
                if (state == AgentPresenceState.CONNECTING) {
                    this.processConnectionDisconnectionEvent(AgentPresenceState.CONNECTING, a);
                } else if (state == AgentPresenceState.CONNECTED) {
                    this.processConnectionDisconnectionEvent(AgentPresenceState.CONNECTING_CONNECTED, a);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectedAgent(AgentInfo ... agents) {
        Object object = this.agentsLock;
        synchronized (object) {
            ArrayList<AgentInfo> disconnectedAgents = new ArrayList<AgentInfo>();
            for (AgentInfo agent : agents) {
                AgentPresenceState state = this.mapAgents.remove(agent);
                if (state == null) continue;
                disconnectedAgents.add(agent);
            }
            if (!disconnectedAgents.isEmpty()) {
                LOG.log(Level.FINER, "disconnecting agents {0}", disconnectedAgents);
                this.processConnectionDisconnectionEvent(AgentPresenceState.DISCONNECTING, disconnectedAgents.toArray(new AgentInfo[disconnectedAgents.size()]));
            }
        }
    }

    public List<AgentInfo> listConnectedAgents() {
        return new ArrayList<AgentInfo>(this.fullyConnectedAgents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForFirstContact(long timeout, TimeUnit unit) {
        AtomicBoolean atomicBoolean = this.firstConnection;
        synchronized (atomicBoolean) {
            if (!this.firstConnection.get()) {
                try {
                    this.firstConnection.wait(unit.toMillis(timeout));
                    this.firstConnectionDone();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void membersLeft(List<String> left) {
        ArrayList<AgentInfo> agentsToRemove = new ArrayList<AgentInfo>();
        Object object = this.agentsLock;
        synchronized (object) {
            for (AgentInfo a : this.mapAgents.keySet()) {
                if (!left.contains(a.getName())) continue;
                agentsToRemove.add(a);
            }
        }
        if (!agentsToRemove.isEmpty()) {
            this.disconnectedAgent(agentsToRemove.toArray(new AgentInfo[agentsToRemove.size()]));
        }
    }

    @Override
    public void membersJoined(List<String> joined) {
        if (joined.size() > 1) {
            DelayedConnectedNotification connectingDelayedNotification = new DelayedConnectedNotification(joined, AgentPresenceState.CONNECTING);
            Thread t = new Thread(connectingDelayedNotification);
            t.start();
            this.delayedNotifications.add(connectingDelayedNotification);
            DelayedConnectedNotification connectedDelayedNotification = new DelayedConnectedNotification(joined, AgentPresenceState.CONNECTED, t);
            Thread t1 = new Thread(connectedDelayedNotification);
            t1.start();
            this.delayedNotifications.add(connectedDelayedNotification);
        }
    }

    public void processConnectionDisconnectionEvent(AgentPresenceState state, AgentInfo ... agentInfos) {
        boolean isDelayed = false;
        for (DelayedConnectedNotification notification : this.delayedNotifications) {
            for (AgentInfo a : agentInfos) {
                if (!notification.processConnectionDisconnectionEvent(a, state)) continue;
                isDelayed = true;
            }
        }
        if (!isDelayed) {
            ConnectionDisconnectionNotification notification = new ConnectionDisconnectionNotification(state, agentInfos);
            try {
                this.notifications.put(notification);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("Problem submitting AgentPresenceManager notifications ", ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentPresenceListener(AgentPresenceListener l) {
        Object object = this.agentsLock;
        synchronized (object) {
            l.connecting(this.mapAgents.keySet().toArray(new AgentInfo[0]));
            l.connected(this.fullyConnectedAgents.toArray(new AgentInfo[0]));
            this.listAPL.add(l);
        }
    }

    public void removeAgentPresenceListener(AgentPresenceListener l) {
        this.listAPL.remove(l);
    }

    public boolean agentExists(String agentName) {
        ArrayList<AgentInfo> existingAgents = new ArrayList<AgentInfo>(this.mapAgents.keySet());
        for (AgentInfo a : existingAgents) {
            if (!a.getName().equals(agentName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentConnected(String agentName) {
        Set<AgentInfo> set = this.fullyConnectedAgents;
        synchronized (set) {
            for (AgentInfo a : this.fullyConnectedAgents) {
                if (!a.getName().equals(agentName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAgentConnected(AgentPropertyPredicate agentPredicate) {
        Set<AgentInfo> set = this.fullyConnectedAgents;
        synchronized (set) {
            for (AgentInfo a : this.fullyConnectedAgents) {
                if (!agentPredicate.test(a)) continue;
                return true;
            }
            return false;
        }
    }

    @Deprecated
    public final boolean waitForAgent(String name, long timeout, TimeUnit unit) throws InterruptedException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("agentName", name);
        AgentPropertyPredicate innerPredicate = new AgentPropertyPredicate(properties);
        return this.waitForAgent(innerPredicate, timeout, unit);
    }

    public final void waitForConnectedAgent(String name, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.waitForAgent(name, timeout, unit)) {
            throw new TimeoutException("Timeout of " + timeout + " " + unit.name() + " exceeded when waiting for agent " + name + " to connect to the buses");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final boolean waitForAgent(AgentPropertyPredicate predicate, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.agentConnectionWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (this.isAgentConnected(predicate)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.agentConnectionWaitLock.newCondition();
            if (this.agentConnectionWaitList == null) {
                this.agentConnectionWaitList = new LinkedHashMap(4);
            }
            this.agentConnectionWaitList.put(condition, predicate);
            while (this.agentConnectionWaitList != null && this.agentConnectionWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                if (this.agentConnectionWaitList != null) {
                    this.agentConnectionWaitList.remove(condition);
                }
                if (this.agentConnectionWaitList.isEmpty()) {
                    this.agentConnectionWaitList = null;
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.agentConnectionWaitLock.unlock();
        }
        return true;
    }

    public final void waitForAgentPredicate(AgentPropertyPredicate predicate, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.waitForAgent(predicate, timeout, unit)) {
            throw new TimeoutException("Timeout of " + timeout + " " + unit.name() + " exceeded when waiting for predicate " + predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentConnectionWaitNotify(AgentInfo agentInfo) {
        try {
            this.agentConnectionWaitLock.lockInterruptibly();
            try {
                if (this.agentConnectionWaitList == null) {
                    return;
                }
                Iterator<Map.Entry<Condition, AgentPropertyPredicate>> it = this.agentConnectionWaitList.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Condition, AgentPropertyPredicate> entry = it.next();
                    AgentPropertyPredicate agentWaitPredicate = entry.getValue();
                    if (!agentWaitPredicate.test(agentInfo)) continue;
                    entry.getKey().signal();
                    it.remove();
                }
                if (this.agentConnectionWaitList.isEmpty()) {
                    this.agentConnectionWaitList = null;
                }
            }
            finally {
                this.agentConnectionWaitLock.unlock();
            }
        }
        catch (InterruptedException x) {
            LOG.log(Level.SEVERE, "Exception when notifying for connection of " + agentInfo.getName() + " in agent " + this.thisAgentInfo.getName(), x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final boolean waitForAgentDisconnection(String name, long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = TimeUnit.MILLISECONDS.convert(timeout, unit) + System.currentTimeMillis();
        if (!this.agentDisconnectionWaitLock.tryLock(timeout, unit)) {
            return false;
        }
        try {
            if (!this.isAgentConnected(name)) {
                boolean bl = true;
                return bl;
            }
            Condition condition = this.agentDisconnectionWaitLock.newCondition();
            if (this.agentDisconnectionWaitList == null) {
                this.agentDisconnectionWaitList = new LinkedHashMap(4);
            }
            this.agentDisconnectionWaitList.put(condition, name);
            while (this.agentDisconnectionWaitList != null && this.agentDisconnectionWaitList.containsKey(condition)) {
                timeout = deadline - System.currentTimeMillis();
                if (condition.await(timeout, TimeUnit.MILLISECONDS)) continue;
                if (this.agentDisconnectionWaitList != null) {
                    this.agentDisconnectionWaitList.remove(condition);
                }
                if (this.agentDisconnectionWaitList.isEmpty()) {
                    this.agentDisconnectionWaitList = null;
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.agentDisconnectionWaitLock.unlock();
        }
        return true;
    }

    public final void waitForDisconnectedAgent(String name, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.waitForAgentDisconnection(name, timeout, unit)) {
            throw new TimeoutException("Timeout of " + timeout + " " + unit.name() + " exceeded when waiting for agent " + name + " to disconnect from the buses.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentDisconnectionWaitNotify(String name) {
        try {
            this.agentDisconnectionWaitLock.lockInterruptibly();
            try {
                if (this.agentDisconnectionWaitList == null) {
                    return;
                }
                Iterator<Map.Entry<Condition, String>> it = this.agentDisconnectionWaitList.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Condition, String> entry = it.next();
                    String agentWaitName = entry.getValue();
                    if (!name.equals(agentWaitName)) continue;
                    entry.getKey().signal();
                    it.remove();
                }
                if (this.agentDisconnectionWaitList.isEmpty()) {
                    this.agentDisconnectionWaitList = null;
                }
            }
            finally {
                this.agentDisconnectionWaitLock.unlock();
            }
        }
        catch (InterruptedException ie) {
            LOG.log(Level.SEVERE, "Exception when notifying for disconnection " + name + " in agent " + this.thisAgentInfo.getName(), ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firstConnectionDone() {
        if (this.firstConnection.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = this.firstConnection;
        synchronized (atomicBoolean) {
            if (!this.firstConnection.get()) {
                this.firstConnection.set(true);
                this.firstConnection.notifyAll();
            }
        }
    }

    public static enum AgentPresenceState {
        CONNECTING_CONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }

    private class DelayedConnectedNotification
    implements Runnable {
        private final List<String> joined;
        private final List<AgentInfo> agentInfos;
        private final Object notificationLock = new Object();
        private final AgentPresenceState state;
        private final Thread connectingThread;

        public DelayedConnectedNotification(List<String> joined, AgentPresenceState state, Thread connectingThread) {
            this.joined = new CopyOnWriteArrayList<String>(joined);
            this.agentInfos = new CopyOnWriteArrayList<AgentInfo>();
            this.state = state;
            this.connectingThread = connectingThread;
        }

        public DelayedConnectedNotification(List<String> joined, AgentPresenceState state) {
            this(joined, state, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.notificationLock;
            synchronized (object) {
                try {
                    this.notificationLock.wait(2000L);
                    if (this.connectingThread != null) {
                        this.connectingThread.join();
                    }
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Agents still missing: " + this.joined, ie);
                }
                finally {
                    ConnectionDisconnectionNotification notification = new ConnectionDisconnectionNotification(this.state, this.agentInfos.toArray(new AgentInfo[this.agentInfos.size()]));
                    AgentPresenceManager.this.notifications.add(notification);
                    AgentPresenceManager.this.delayedNotifications.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean processConnectionDisconnectionEvent(AgentInfo agentInfo, AgentPresenceState state) {
            Object object = this.notificationLock;
            synchronized (object) {
                if (state == AgentPresenceState.CONNECTING_CONNECTED || state == this.state) {
                    boolean alreadyInState = this.agentInfos.contains(agentInfo);
                    if (this.joined.remove(agentInfo.getName()) || alreadyInState) {
                        if (!alreadyInState) {
                            this.agentInfos.add(agentInfo);
                        }
                        if (this.joined.isEmpty()) {
                            this.notificationLock.notify();
                        }
                        return true;
                    }
                    return false;
                }
                if (state == AgentPresenceState.DISCONNECTING) {
                    this.joined.remove(agentInfo.getName());
                    this.agentInfos.remove(agentInfo);
                    if (this.joined.isEmpty()) {
                        this.notificationLock.notify();
                    }
                    return false;
                }
                return false;
            }
        }
    }

    private class ConnectionDisconnectionNotification
    implements Runnable {
        private final AgentInfo[] agentInfos;
        private final AgentPresenceState state;

        ConnectionDisconnectionNotification(AgentPresenceState state, AgentInfo ... agentInfos) {
            this.agentInfos = agentInfos;
            this.state = state;
        }

        @Override
        public void run() {
            AgentPresenceManager.this.agentMessagingLayer.waitForMessageLayerConnection();
            LOG.log(Level.FINEST, "Processing APL notifications for state {0} and agents {1}", new Object[]{this.state, Arrays.asList(this.agentInfos)});
            switch (this.state) {
                case DISCONNECTING: {
                    AgentPresenceManager.this.listAPL.forEach(l -> {
                        try {
                            l.disconnected(this.agentInfos);
                        }
                        catch (RuntimeException x) {
                            this.warn((AgentPresenceListener)l, x, this.state);
                        }
                    });
                    for (AgentInfo agentInfo : this.agentInfos) {
                        AgentPresenceManager.this.fullyConnectedAgents.remove(agentInfo);
                        AgentPresenceManager.this.agentDisconnectionWaitNotify(agentInfo.getName());
                    }
                    break;
                }
                case CONNECTING_CONNECTED: 
                case CONNECTING: {
                    AgentPresenceManager.this.listAPL.forEach(l -> {
                        try {
                            l.connecting(this.agentInfos);
                        }
                        catch (RuntimeException x) {
                            this.warn((AgentPresenceListener)l, x, this.state);
                        }
                    });
                    if (this.state == AgentPresenceState.CONNECTING) break;
                }
                case CONNECTED: {
                    AgentPresenceManager.this.listAPL.forEach(l -> {
                        try {
                            l.connected(this.agentInfos);
                        }
                        catch (RuntimeException x) {
                            this.warn((AgentPresenceListener)l, x, this.state);
                        }
                    });
                    for (AgentInfo agentInfo : this.agentInfos) {
                        if (!AgentPresenceManager.this.fullyConnectedAgents.add(agentInfo)) continue;
                        AgentPresenceManager.this.agentConnectionWaitNotify(agentInfo);
                    }
                    AgentPresenceManager.this.firstConnectionDone();
                }
            }
        }

        private void warn(AgentPresenceListener listener, RuntimeException x, AgentPresenceState state) {
            String agents = this.agentInfos.length == 1 ? this.agentInfos[0].getName() : Arrays.asList(this.agentInfos).stream().map(a -> a.getName()).collect(Collectors.joining(", ", "[", "]"));
            LOG.log(Level.WARNING, "Exception while notifying " + listener.getClass().getSimpleName() + " of " + (Object)((Object)state) + " of " + agents, x);
        }
    }
}

