package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.CommandNack;

/**
 * Originator of a command.
 * Once an agent receives the reply of a command, it passes it to its list of 
 * command originators. The originator with the matching correlation ID can then
 * process the command response.
 * 
 * @author emarin
 */
public interface CommandOriginator {

    /**
     * Callback method with the CommandAck returned by the CommandRequest
     * destination agent; it signifies that the CommandRequest
     * has been received and accepted by the command destination.
     * 
     * @param ack The CommandAck acknowledging that the command was accepted.
     */    
    default void processAck(CommandAck ack) {
        
    }

    /**
     * Callback method with the CommandResult returned by the CommandRequest
     * destination agent; it contains the result of the command's execution.
     * 
     * @param result The CommandResult containing the execution's result.
     */    
    default void processResult (CommandResult result) {
        
    }
    
    /**
     * Callback method with the CommandNack returned by the CommandRequest
     * destination agent; it signifies that the CommandRequest
     * has been received but declined by the command destination.
     * 
     * @param nack The CommandNack acknowledging that the command was received
     *             but rejected by the command's destination.
     */    
    default void processNack(CommandNack nack) {
        
    }
}
