/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.messaging.util.KeyQueueExecutor;

public class KeyQueueExecutorTest {
    final int N = 100;
    final int MAX_TASK_DURATION = 5;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testExecute() {
        KeyQueueExecutor exec = new KeyQueueExecutor("EXEC", 5);
        int nSources = 10;
        ArrayList<Source> sources = new ArrayList<Source>(nSources);
        for (int i = 0; i < nSources; ++i) {
            sources.add(new Source(String.valueOf(i)));
        }
        Source namelessSource = new Source(null);
        CountDownLatch latchStart = new CountDownLatch(nSources + 1);
        CountDownLatch latchEnd = new CountDownLatch(nSources + 1);
        namelessSource.publish(exec, latchStart, latchEnd);
        sources.forEach(s -> s.publish(exec, latchStart, latchEnd));
        try {
            boolean done = latchEnd.await(1L, TimeUnit.MINUTES);
            if (!done) {
                Assert.fail((String)"Not finished withing 1 munute");
            }
        }
        catch (InterruptedException x) {
            Assert.fail((String)"Main Thread interrupted");
        }
        namelessSource.check();
        sources.forEach(s -> s.check());
        exec.shutdownNow();
    }

    @Test
    public void testLogicBranches() {
        StringBuffer sb = new StringBuffer();
        KeyQueueExecutor exec = new KeyQueueExecutor("EXEC", 3);
        exec.execute((Runnable)new LogicBranchesTask(sb, 2000L, "a"), new String[]{"a"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 1000L, "b"), new String[]{"b"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 500L, "a"), new String[]{"a"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 1500L, "c"), new String[]{"c"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 0L, "d"), new String[]{"d"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 2500L, "d"), new String[]{"d"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 0L, "1"), new String[]{"a", "b", "c"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 0L, "a"), new String[]{"a"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 500L, "b"), new String[]{"b"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 0L, "2"), new String[]{"a", "b", "c", "d"});
        this.drain(exec);
        sb.append("_");
        exec.execute((Runnable)new LogicBranchesTask(sb, 500L, "a"), new String[]{"a"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 1000L, "b"), new String[]{"b"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 1500L, "c"), new String[]{"c"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 0L, "1"), new String[]{"a", "b", "c"});
        exec.execute((Runnable)new LogicBranchesTask(sb, 0L, "0"), new String[0]);
        this.drain(exec);
        Assert.assertEquals((String)"testLogicBranches", (Object)"bdcaa1abd2_a0bc1", (Object)sb.toString());
    }

    private void drain(KeyQueueExecutor exec) {
        CountDownLatch latch = new CountDownLatch(1);
        exec.execute(() -> latch.countDown(), new String[]{"a", "b", "c", "d", "e", "f", "g", "h"});
        try {
            boolean done = latch.await(1L, TimeUnit.MINUTES);
            if (!done) {
                Assert.fail((String)"testLogicBranches not done withing 1 munute");
            }
        }
        catch (InterruptedException x) {
            Assert.fail((String)"testLogicBranches interrupted");
        }
    }

    private class Source {
        final String queue;
        int received;

        Source(String queue) {
            this.queue = queue;
        }

        void publish(KeyQueueExecutor exec, CountDownLatch latchStart, final CountDownLatch latchEnd) {
            new Thread(() -> {
                final ThreadLocalRandom random = ThreadLocalRandom.current();
                latchStart.countDown();
                try {
                    latchStart.await();
                    int i = 0;
                    while (i < 100) {
                        int delay = random.nextInt(3);
                        if (delay > 0) {
                            try {
                                Source source = this;
                                synchronized (source) {
                                    this.wait(delay);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        final int ii = i++;
                        exec.execute(new Runnable(){
                            final int id;
                            {
                                this.id = ii;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object;
                                int delay = random.nextInt(5);
                                if (delay > 0) {
                                    try {
                                        object = this;
                                        synchronized (object) {
                                            this.wait(delay);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                if (Source.this.queue == null) {
                                    object = "LOCK for received";
                                    synchronized ("LOCK for received") {
                                        if (++Source.this.received == 100) {
                                            latchEnd.countDown();
                                        }
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                    }
                                } else {
                                    Assert.assertEquals((String)Source.this.queue, (long)Source.this.received, (long)this.id);
                                    if (++Source.this.received == 100) {
                                        latchEnd.countDown();
                                    }
                                }
                            }
                        }, new String[]{this.queue});
                    }
                }
                catch (InterruptedException x) {
                    Assert.fail((String)"Thread interrupted while waiting to publish");
                }
            }).start();
        }

        void check() {
            Assert.assertEquals((String)(this.queue + " received: "), (long)100L, (long)this.received);
        }
    }

    private static class LogicBranchesTask
    implements Runnable {
        final StringBuffer sb;
        final long delay;
        final String mark;

        public LogicBranchesTask(StringBuffer sb, long delay, String mark) {
            this.sb = sb;
            this.delay = delay;
            this.mark = mark;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sb.append(this.mark);
        }
    }
}

