package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.BusMessage;

/**
 * A <TT>BusMessageForwarder</TT> receives a <TT>BusMessage</TT> from the transport layer
 * and passes it to registered MessageListener.
 * <P>
 *     Typically a code implementing this contract will consider which is the actual subclass
 *     of <TT>BusMessage</TT> which is used in the update and forward it to the appropriate listeners.
 *     But there could also be different forwarders for different bus.
 *     <P>
 *     these implementations can also tag the context of the thread dealing with this message with correlation data.
 *     <P>
 *     It is thus of utmost importance to consider that each transport layer that  calls <TT>update</TT>
 *     waits for the completion of the Listener code or calls other updates in a different thread.
*      <P> this class is part of version 2 of the communication framework
 */
public interface BusMessageForwarder<T extends BusMessage> {
    public void update(T message);
}
