package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.CommandRequest;

/**
 * The Command executor receives a command and executes it.
 * It is unique inside an agent, as the destination of a CommandRequest is the 
 * name with which the agent is connected.
 * 
 * @author emarin
 */
public interface CommandExecutor {
    
    /**
     * Executes the received command
     * @param cmd the command to be executed by the CommandExecutor 
     */
    void executeCommandRequest(CommandRequest cmd);
    
}
