/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.tracers.Names;

public class CcsTestCaseTemplate {
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println("Starting test: " + description.getMethodName());
        }
    };
    protected String transport;
    private BrokerService broker;

    public CcsTestCaseTemplate() {
        this("jgroups:udp_ccs:");
    }

    public CcsTestCaseTemplate(String transport) {
        System.setProperty("org.lsst.ccs.messaging.new.publication.strategy", "false");
        this.setTransport(transport);
        System.setProperty("org.lsst.ccs.subsystem.agent.property.group", String.valueOf(System.currentTimeMillis()));
        System.setProperty("org.lsst.ccs.monitoring.default.check", "alarm");
    }

    private void setTransport(String transport) {
        this.transport = transport;
        System.setProperty("org.lsst.ccs.transport", transport);
    }

    protected String getTransport() {
        return this.transport;
    }

    @Before
    public void initServers() {
        if (this.transport.startsWith("jms")) {
            System.setProperty("org.apache.activemq.default.directory.prefix", "./target/");
            this.broker = new BrokerService();
            try {
                this.broker.addConnector("tcp://localhost:34211");
                this.broker.start();
                this.broker.waitUntilStarted();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @After
    public void tearDownServers() {
        if (this.transport.startsWith("jms")) {
            try {
                this.broker.stop();
                this.broker.waitUntilStopped();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @BeforeClass
    public static void setupEnvironment() {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("java.net.preferIPv6Addresses", "false");
        System.setProperty("org.lsst.ccs.config.WriterProvider", "org.lsst.ccs.config.InMemoryFileWriterProvider");
        System.setProperty("org.lsst.ccs.subsystem.agent.property.group", String.valueOf(System.currentTimeMillis()));
        System.setProperty("org.lsst.ccs.logging.StackTraceFormats.depth", "-1");
    }

    @AfterClass
    public static void printMessagingLayerInformation() throws Exception {
        List messagingAccesses = AgentMessagingLayer.getMessagingAccesses();
        if (messagingAccesses.size() > 0) {
            System.out.println("*********************************");
            System.out.println("***** MessagingAccess left open: " + messagingAccesses.size());
            System.out.println();
            int count = 0;
            for (AgentMessagingLayer msgAcc : messagingAccesses) {
                System.out.println(" -" + ++count + "-");
                AgentMessagingLayer.printMessagingAccessInfo((AgentMessagingLayer)msgAcc);
                System.out.println();
            }
            System.out.println("*********************************");
        }
        System.setProperty("org.lsst.ccs.transport", "jgroups:udp_ccs");
    }

    protected String genTestName(String seed) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length > 2) {
            String longClassName = trace[2].getClassName();
            String testClassName = longClassName.substring(longClassName.lastIndexOf(46) + 1);
            String testMethodName = trace[2].getMethodName();
            return String.format("%s_%s_%s", seed, testClassName, testMethodName);
        }
        return Names.almostUniqueAgentName((String)seed);
    }
}

