package org.lsst.ccs.messaging;

import org.lsst.ccs.bus.messages.LogMessage;

/**
 * Interface to be implemented by listeners that wish to be notified of messages
 * received on the LOG bus.
 *
 * @author emarin
 */
public interface LogMessageListener extends MessageListener {

    /**
     * Called when the message is received.
     * The implementation should be thread-safe: the framework makes no guarantees
     * on what thread this method will be called on, and it can be called concurrently
     * for several messages.
     * 
     * The implementation should also return immediately : any blocking operations
     * should be scheduled on a separate thread.

     * 
     * @param msg Log bus message to be processed.
     */
    public void onLogMessage(LogMessage msg);
    
}
