/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.utilities.logging.Logger;

public class StateBundleAggregator
implements StatusMessageListener,
AgentPresenceListener {
    static Logger log = Logger.getLogger((String)"lsst.ccs.bus");
    private final AgentMessagingLayer messagingLayer;
    Set<String> origins = new HashSet<String>();
    Set<String> isAvailable = new HashSet<String>();
    private final Object updateLock = new Object();
    Map<String, StateBundle> states = new ConcurrentHashMap<String, StateBundle>();
    ArrayList<Observer> observers = new ArrayList();

    public StateBundleAggregator(AgentMessagingLayer messagingLayer) {
        this.messagingLayer = messagingLayer;
        this.messagingLayer.getAgentPresenceManager().addAgentPresenceListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrigin(String origin) {
        Object object = this.updateLock;
        synchronized (object) {
            this.origins.add(origin);
            if (this.messagingLayer.getAgentPresenceManager().agentExists(origin)) {
                this.isAvailable.add(origin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusMessage(StatusMessage msg) {
        String origin = msg.getOriginAgentInfo().getName();
        Object object = this.updateLock;
        synchronized (object) {
            if (!this.isAvailable.contains(origin)) {
                return;
            }
            if (!this.origins.contains(origin)) {
                return;
            }
            if (this.observers.isEmpty()) {
                return;
            }
            StateBundle oldBundle = this.states.get(origin);
            StateBundle newBundle = null;
            if (oldBundle == null) {
                newBundle = msg.getState();
                oldBundle = new StateBundle(new Enum[0]);
            } else if (msg instanceof StatusStateChangeNotification) {
                newBundle = msg.getState();
            }
            if (newBundle != null) {
                StateBundle diff = newBundle.diffState(oldBundle);
                StateBundle outDiff = oldBundle.diffState(newBundle);
                log.debug((Object)("state of " + origin + " changed : " + diff));
                this.notifyObservers(origin, outDiff, diff);
                this.states.put(origin, newBundle);
            }
        }
    }

    public synchronized void addObserver(Observer o) {
        this.observers.add(o);
    }

    public synchronized void deleteObserver(Observer o) {
        this.observers.remove(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(String origin, StateBundle old, StateBundle change) {
        ArrayList<Observer> obs;
        StateBundleAggregator stateBundleAggregator = this;
        synchronized (stateBundleAggregator) {
            obs = new ArrayList<Observer>(this.observers);
        }
        for (Observer o : obs) {
            o.stateChanged(origin, old, change);
        }
    }

    public StateBundle getState(String origin) {
        return this.states.get(origin);
    }

    public Map<String, StateBundle> getStates() {
        return Collections.unmodifiableMap(this.states);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connecting(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            String name = agent.getName();
            Object object = this.updateLock;
            synchronized (object) {
                if (this.origins.contains(name)) {
                    this.isAvailable.add(name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            String name = agent.getName();
            Object object = this.updateLock;
            synchronized (object) {
                boolean wasThere = this.isAvailable.remove(name);
                if (wasThere) {
                    this.states.remove(name);
                }
            }
        }
    }

    public static interface Observer {
        public void stateChanged(String var1, StateBundle var2, StateBundle var3);
    }
}

