/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.messaging.util.LegacyDispatcher;
import org.lsst.ccs.messaging.util.MultiQueueDispatcher;

public class DispatcherTest {
    final int N = 200;
    final int MAX_TASK_DURATION = 200;
    final int N_AGENTS = 5;
    final int NB = 2 * Bus.values().length * Dispatcher.Order.values().length;
    final Object[] locks = new Object[this.NB];
    final int[] sent = new int[this.NB];
    final Random rand = new Random();
    final ArrayList<Dispatcher.Status> reports = new ArrayList();
    final int[] received = new int[this.NB];
    final EnumMap<Bus, int[]> receivedPerAgent = new EnumMap(Bus.class);
    private volatile Dispatcher dispatcher;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    public DispatcherTest() {
        for (int i = 0; i < this.NB; ++i) {
            this.locks[i] = new Object();
        }
    }

    @Test
    public void test() {
        Dispatcher[] dd;
        System.out.println("Start");
        for (Dispatcher d : dd = new Dispatcher[]{new LegacyDispatcher(new String[]{"periods=0:2"}), new MultiQueueDispatcher(new String[]{"periods=0:2"})}) {
            System.out.println("Starting testing " + d.getClass().getSimpleName());
            this.dispatcher = d;
            this.clear(0);
            this.dispatcher.initialize();
            d.addStatusListener(status -> this.reports.add(status));
            for (int i = 0; i < 200; ++i) {
                this.startTask();
            }
            if (this.dispatcher instanceof MultiQueueDispatcher) {
                ((MultiQueueDispatcher)this.dispatcher).drainAndShutdown();
            } else {
                this.dispatcher.shutdown();
            }
            Assert.assertArrayEquals((String)"Descrepancy between numbers of started and finished tasks", (int[])this.sent, (int[])this.received);
            System.out.println("End test " + this.dispatcher.getClass().getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(int lockIndex) {
        if (lockIndex < this.NB) {
            Object object = this.locks[lockIndex];
            synchronized (object) {
                this.clear(lockIndex + 1);
            }
        } else {
            Arrays.fill(this.sent, 0);
            this.reports.clear();
            Arrays.fill(this.received, 0);
            for (Bus bus : Bus.values()) {
                this.receivedPerAgent.put(bus, new int[5]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask() {
        int index = this.rand.nextInt(this.NB);
        boolean in = this.getIn(index);
        Bus bus = this.getBus(index);
        Dispatcher.Order order = this.getOrder(index);
        int[] agents = new int[]{};
        if (in && order == Dispatcher.Order.NORM) {
            int n = this.rand.nextInt(6);
            if (n == 5) {
                int i;
                ArrayList<Integer> all = new ArrayList<Integer>(5);
                for (i = 0; i < 5; ++i) {
                    all.add(i);
                }
                Collections.shuffle(all, this.rand);
                n = this.rand.nextInt(5);
                agents = new int[n];
                for (i = 0; i < n; ++i) {
                    agents[i] = (Integer)all.get(i);
                }
            } else {
                agents = new int[]{n};
            }
        }
        String[] agentNames = new String[agents.length];
        for (int i = 0; i < agents.length; ++i) {
            agentNames[i] = Integer.toString(agents[i]);
        }
        Object object = this.locks[index];
        synchronized (object) {
            int n = index;
            int n2 = this.sent[n] + 1;
            this.sent[n] = n2;
            Task task = new Task(n2, index, agents);
            if (in) {
                this.dispatcher.in((Runnable)task, bus, agentNames);
            } else {
                this.dispatcher.out((Runnable)task, bus, order);
            }
        }
    }

    boolean getIn(int index) {
        return index < this.NB / 2;
    }

    Bus getBus(int index) {
        index %= this.NB / 2;
        return Bus.values()[index /= Dispatcher.Order.values().length];
    }

    Dispatcher.Order getOrder(int index) {
        index %= this.NB / 2;
        return Dispatcher.Order.values()[index %= Dispatcher.Order.values().length];
    }

    class Task
    implements Runnable {
        final int id;
        final int index;
        final int[] agents;

        Task(int id, int index, int[] agents) {
            this.id = id;
            this.index = index;
            this.agents = agents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int wait = DispatcherTest.this.rand.nextInt(200);
            if (wait > 100) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean in = DispatcherTest.this.getIn(this.index);
            Bus bus = DispatcherTest.this.getBus(this.index);
            Dispatcher.Order order = DispatcherTest.this.getOrder(this.index);
            Object object = DispatcherTest.this.locks[this.index];
            synchronized (object) {
                int n = this.index;
                DispatcherTest.this.received[n] = DispatcherTest.this.received[n] + 1;
                if (order == Dispatcher.Order.NORM) {
                    int[] ra = DispatcherTest.this.receivedPerAgent.get(bus);
                    for (int agent : this.agents) {
                        Assert.assertTrue((String)("Out of order: " + in + " " + bus + " " + agent), (ra[agent] < this.id ? 1 : 0) != 0);
                        ra[agent] = this.id;
                    }
                }
            }
            wait = DispatcherTest.this.rand.nextInt(200);
            if (wait > 100) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

