package org.lsst.ccs.messaging;

/**
 * This exception is thrown when an agent tries to connect with a non unique name.
 * @author emarin
 */
public class DuplicateAgentNameException extends RuntimeException {
   public final String name ;
    public final String additionalInformation ;

    public DuplicateAgentNameException(String name, String additionalInformation) {
        this.name = name;
        this.additionalInformation = additionalInformation;
    }
    
    public String toString() {
        return super.toString() + " " + name + " ("
                + additionalInformation + ")" ;
    }  
}
