/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.messaging.BusMessageForwarder;
import org.lsst.ccs.messaging.MessageListener;

public class MessagingAccessLayer {
    private final String name;
    private final EnumMap<Bus, BusAccess> busAccesses = new EnumMap(Bus.class);

    public MessagingAccessLayer(String name, BusAccess ... buses) {
        this.name = name;
        for (BusAccess busAccess : buses) {
            this.busAccesses.put(busAccess.getBus(), busAccess);
        }
    }

    public String getName() {
        return this.name;
    }

    public Collection<BusAccess> getBusAccesses() {
        return this.busAccesses.values();
    }

    public BusAccess getBusAccess(Bus bus) {
        return this.busAccesses.get(bus);
    }

    public static class BusAccess<T extends BusMessage> {
        private final Map<MessageListener, BusMessageForwarder> forwarderMap = Collections.synchronizedMap(new LinkedHashMap());
        private final Bus bus;
        private final List<Predicate<BusMessage<? extends Serializable, ?>>> filters = new CopyOnWriteArrayList();

        public BusAccess(Bus bus) {
            this.bus = bus;
        }

        public Bus getBus() {
            return this.bus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processBusMessage(T message) {
            ArrayList<BusMessageForwarder> c;
            if (!this.acceptBusMessage((BusMessage)message)) {
                return;
            }
            Map<MessageListener, BusMessageForwarder> map = this.forwarderMap;
            synchronized (map) {
                c = new ArrayList<BusMessageForwarder>(this.forwarderMap.values());
            }
            for (BusMessageForwarder bmf : c) {
                bmf.update(message);
            }
        }

        public void addForwarder(MessageListener l, BusMessageForwarder forwarder) {
            this.forwarderMap.put(l, forwarder);
        }

        public void removeForwarder(MessageListener l) {
            this.forwarderMap.remove(l);
        }

        public void processClusterDeserializationError(String address, RuntimeException e) {
        }

        public void addBusMessageFilter(Predicate<BusMessage<? extends Serializable, ?>> filter) {
            this.filters.add(filter);
        }

        private boolean acceptBusMessage(BusMessage msg) {
            if (this.filters.isEmpty()) {
                return true;
            }
            for (Predicate<BusMessage<Serializable, ?>> filter : this.filters) {
                boolean accept = filter.test(msg);
                if (accept) continue;
                return false;
            }
            return true;
        }
    }
}

