/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bus.definition.Bus;
import org.lsst.ccs.messaging.util.Dispatcher;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class AbstractDispatcher
implements Dispatcher {
    private static final Logger LOGGER = Logger.getLogger((String)"org.lsst.ccs.messaging.Dispatcher");
    private static final int[] DEF_PERIODS = new int[0];
    protected static final Timer timer = new Timer("Dispatcher timer", true);
    private final int[] periods;
    private final Status statusAccumulator;
    private volatile Status statusOut;
    private final Task[] statusTasks;
    private final CopyOnWriteArrayList<Dispatcher.StatusListener> listeners = new CopyOnWriteArrayList();

    protected AbstractDispatcher(String ... args) {
        int[] pp = this.getIntArrayArg("periods", args);
        if (pp == null) {
            this.periods = DEF_PERIODS;
        } else {
            Arrays.sort(pp);
            this.periods = pp;
        }
        if (this.periods.length == 0) {
            this.statusAccumulator = null;
            this.statusTasks = new Task[0];
        } else {
            this.statusAccumulator = new Status(this.periods, true);
            ArrayList<Task> tasks = new ArrayList<Task>();
            for (int pid = 0; pid < this.periods.length; ++pid) {
                int seconds = this.periods[pid];
                if (seconds <= 0) continue;
                boolean needsNewTask = true;
                for (Task task : tasks) {
                    if (seconds % task.getPeriod() != 0) continue;
                    task.add(pid);
                    needsNewTask = false;
                    break;
                }
                if (!needsNewTask) continue;
                Task t = new Task(pid);
                tasks.add(t);
            }
            this.statusTasks = tasks.toArray(new Task[tasks.size()]);
            this.statusOut = new Status(this.periods, true);
        }
    }

    @Override
    public void initialize() {
        for (Task task : this.statusTasks) {
            timer.scheduleAtFixedRate((TimerTask)task, 0L, (long)task.getPeriod() * 1000L);
        }
    }

    @Override
    public void shutdown() {
        for (Task task : this.statusTasks) {
            task.cancel();
        }
    }

    protected void report(Runnable run, long taskID, boolean incoming, Bus bus, Dispatcher.Order order, long duration, Dispatcher.Stage ... stages) {
        if (run instanceof Dispatcher.Task) {
            ((Dispatcher.Task)run).stageEnded(stages);
        }
        if (this.statusAccumulator != null) {
            this.statusAccumulator.addReport(taskID, incoming, bus, order, duration, stages);
        }
    }

    protected void updateStatistics(ArrayList<Integer> ids) {
        Status out;
        if (this.periods[0] == 0) {
            ids.add(0);
        }
        this.statusOut = out = this.statusAccumulator.compute(ids, this.statusOut);
        this.notifyListeners(out);
    }

    @Override
    public Status getStatus() {
        return this.statusOut;
    }

    @Override
    public void addStatusListener(Dispatcher.StatusListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeStatusListener(Dispatcher.StatusListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(Status status) {
        for (Dispatcher.StatusListener listener : this.listeners) {
            try {
                listener.statusChanged(status);
            }
            catch (Exception x) {
                Logger logger = this.getLogger();
                if (logger == null) continue;
                this.getLogger().warn((Object)("Error notifying " + listener + " of " + this.getClass().getSimpleName() + " status change."), (Throwable)x);
            }
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected final Integer getIntegerArg(String key, String[] args) {
        for (String arg : args) {
            String[] ss = arg.split("=");
            if (ss.length != 2 || !ss[0].equals(key)) continue;
            return Integer.parseInt(ss[1]);
        }
        return null;
    }

    protected final int[] getIntArrayArg(String key, String[] args) {
        for (String arg : args) {
            String[] ss = arg.split("=");
            if (ss.length != 2 || !ss[0].equals(key)) continue;
            ss = ss[1].split(":");
            int[] out = new int[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                out[i] = Integer.parseInt(ss[i]);
            }
            return out;
        }
        return null;
    }

    private class Task
    extends TimerTask {
        private int[] periodIDs;
        private int[] count;

        Task(int periodID) {
            this.periodIDs = new int[]{periodID};
            this.count = new int[]{1};
        }

        @Override
        public void run() {
            int n = this.count.length;
            ArrayList<Integer> id = new ArrayList<Integer>(n);
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.count[n2] = this.count[n2] - 1;
                if (this.count[n2] != 0) continue;
                id.add(this.periodIDs[i]);
                this.count[i] = AbstractDispatcher.this.periods[this.periodIDs[i]] / this.getPeriod();
            }
            AbstractDispatcher.this.updateStatistics(id);
        }

        int getPeriod() {
            return AbstractDispatcher.this.periods[this.periodIDs[0]];
        }

        void add(int periodID) {
            int n = this.periodIDs.length;
            this.periodIDs = Arrays.copyOf(this.periodIDs, n + 1);
            this.periodIDs[n] = periodID;
            this.count = Arrays.copyOf(this.periodIDs, n + 1);
            int period = AbstractDispatcher.this.periods[periodID];
            this.count[n] = period / this.getPeriod();
        }
    }

    protected static class Bin {
        protected long n;
        protected long timeSum;
        protected long timeMax;

        protected Bin() {
        }
    }

    protected static class Bucket {
        protected EnumMap<Dispatcher.Stage, Bin> bins;

        protected Bucket() {
            this.init();
        }

        protected Bucket(Bucket other) {
            this.bins = other.bins;
        }

        protected void init() {
            this.bins = new EnumMap(Dispatcher.Stage.class);
            for (Dispatcher.Stage stage : Dispatcher.Stage.values()) {
                this.bins.put(stage, new Bin());
            }
        }

        protected Bucket compute() {
            Bucket out = new Bucket(this);
            for (Bin bin : out.bins.values()) {
                if (bin.n <= 0L) continue;
                bin.timeSum /= bin.n;
            }
            this.init();
            return out;
        }
    }

    protected static class Status
    implements Dispatcher.Status {
        private final int[] periods;
        private final Bucket[] buckets;
        private final int cIncoming;
        private final int cBus;
        private final int nPeriods;

        protected Status(int[] periods, boolean createBuckets) {
            this.periods = periods;
            this.nPeriods = periods.length;
            this.cBus = Dispatcher.Order.values().length * this.nPeriods;
            this.cIncoming = Bus.values().length * this.cBus;
            this.buckets = new Bucket[2 * this.cIncoming];
            if (createBuckets) {
                for (int i = 0; i < 2 * this.cIncoming; ++i) {
                    this.buckets[i] = new Bucket();
                }
            }
        }

        @Override
        public long getTime(boolean incoming, Bus bus, Dispatcher.Order order, Dispatcher.Stage stage, Dispatcher.Stat stat, int periodID) {
            Bin bin = this.getBin(incoming, bus, order, stage, periodID);
            switch (stat) {
                case MAX: {
                    return bin.timeMax;
                }
                case AVERAGE: {
                    return bin.timeSum;
                }
            }
            return 0L;
        }

        @Override
        public long getCompletedTasks(boolean incoming, Bus bus, Dispatcher.Order order, Dispatcher.Stage stage, int periodID) {
            return this.getBin((boolean)incoming, (Bus)bus, (Dispatcher.Order)order, (Dispatcher.Stage)stage, (int)periodID).n;
        }

        protected final int getBucketIndex(boolean incoming, Bus bus, Dispatcher.Order order, int periodID) {
            return (incoming ? 0 : 1) * this.cIncoming + bus.ordinal() * this.cBus + order.ordinal() * this.nPeriods + periodID;
        }

        protected final Bucket getBucket(boolean incoming, Bus bus, Dispatcher.Order order, int periodID) {
            return this.buckets[this.getBucketIndex(incoming, bus, order, periodID)];
        }

        protected Bin getBin(boolean incoming, Bus bus, Dispatcher.Order order, Dispatcher.Stage stage, int periodID) {
            return this.getBucket((boolean)incoming, (Bus)bus, (Dispatcher.Order)order, (int)periodID).bins.get((Object)stage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addReport(long taskID, boolean incoming, Bus bus, Dispatcher.Order order, long duration, Dispatcher.Stage ... stages) {
            int i0 = this.getBucketIndex(incoming, bus, order, 0);
            Bucket bucket = this.buckets[i0];
            synchronized (bucket) {
                for (int i = i0; i < i0 + this.nPeriods; ++i) {
                    Bucket bucket2 = this.buckets[i];
                    for (Dispatcher.Stage stage : stages) {
                        Bin bin = bucket2.bins.get((Object)stage);
                        ++bin.n;
                        bin.timeSum += duration;
                        if (duration <= bin.timeMax) continue;
                        bin.timeMax = duration;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Status compute(List<Integer> ids, Status previous) {
            Status out = new Status(previous.periods, false);
            for (int i0 = 0; i0 < this.buckets.length; i0 += this.nPeriods) {
                Bucket bucket = this.buckets[i0];
                synchronized (bucket) {
                    for (int i : ids) {
                        out.buckets[i0 + i] = this.buckets[i0 + i].compute();
                    }
                    continue;
                }
            }
            for (int i = 0; i < this.buckets.length; ++i) {
                if (out.buckets[i] != null) continue;
                out.buckets[i] = previous.buckets[i];
            }
            return out;
        }
    }
}

