package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.Objects;

import org.lsst.ccs.bus.data.AgentLock;

/**
 * A dummy lock used for preliminary implementation of the agent lock service.
 * 
 * @author LSST CCS Team
 */
public class DummyLock implements AgentLock, Serializable {
    private static final long serialVersionUID = 5818640455315154768L;

    private final String agentName;
    private final String owner;
    private final int maxLevel = 99;

    public DummyLock(String agentName, String owner) {
        this.agentName = agentName;
        this.owner = owner;
    }

    public DummyLock(String agentName) {
        this(agentName, null);
    }

    @Override
    public String getAgentName() {
        return agentName;
    }

    @Override
    public int getMaxLevel() {
        return maxLevel;
    }

    @Override
    public String getToken() {
        return "LOCK-001";
    }

    @Override
    public String getOwner() {
        return owner;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.agentName);
        hash = 67 * hash + Objects.hashCode(this.owner);
        hash = 67 * hash + this.maxLevel;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DummyLock other = (DummyLock) obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        if (!Objects.equals(this.owner, other.owner)) {
            return false;
        }
        if (this.maxLevel != other.maxLevel) {
            return false;
        }
        return true;
    }

}
