/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging;

import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.StatusAggregator;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class StatusAggregatorTest {
    @Test
    public void testAgregator() {
        int i;
        StatusAggregator sa = new StatusAggregator();
        sa.setAggregate("sys1/val1", -1, -1);
        sa.setAggregate("sys1/val2", 100, -1);
        sa.setAggregate("sys2/val1", -1, 200);
        sa.setAggregate("sys3/val1", 50, 300);
        sa.setAggregate("$s/val2", 300, 50);
        sa.setVariable("s", "sys3");
        AgentInfo a1 = new AgentInfo("sys1", AgentInfo.AgentType.WORKER);
        AgentInfo a2 = new AgentInfo("sys2", AgentInfo.AgentType.WORKER);
        AgentInfo a3 = new AgentInfo("sys3", AgentInfo.AgentType.WORKER);
        AgentInfo a4 = new AgentInfo("sys4", AgentInfo.AgentType.WORKER);
        long offset = 2982009600000L;
        for (int i2 = 0; i2 < 10000; ++i2) {
            double val = Math.sin(i2);
            long ts = 2982009600000L + (long)i2;
            KeyValueDataList l1 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l1.addData("val1", (Serializable)Double.valueOf(val));
            l1.addData("val2", (Serializable)Double.valueOf(val));
            StatusSubsystemData s1 = new StatusSubsystemData((KeyValueData)l1);
            s1.setOriginAgentInfo(a1);
            KeyValueDataList l2 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l2.addData("val1", (Serializable)Double.valueOf(val));
            StatusSubsystemData s2 = new StatusSubsystemData((KeyValueData)l2);
            s2.setOriginAgentInfo(a2);
            KeyValueDataList l3 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l3.addData("val1", (Serializable)Double.valueOf(val));
            l3.addData("val2", (Serializable)Double.valueOf(val));
            StatusSubsystemData s3 = new StatusSubsystemData((KeyValueData)l3);
            s3.setOriginAgentInfo(a3);
            KeyValueDataList l4 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l4.addData("val1", (Serializable)Double.valueOf(val));
            StatusSubsystemData s4 = new StatusSubsystemData((KeyValueData)l4);
            s4.setOriginAgentInfo(a4);
            sa.onStatusMessage((StatusMessage)s1);
            sa.onStatusMessage((StatusMessage)s2);
            sa.onStatusMessage((StatusMessage)s3);
            sa.onStatusMessage((StatusMessage)s4);
        }
        Assert.assertEquals((String)"sys1/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val1")), (double)0.001);
        Assert.assertEquals((String)"sys1/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val2")), (double)0.001);
        Assert.assertEquals((String)"sys2/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys2/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val2")), (double)0.001);
        Assert.assertNull((String)"sys4/val1 null", (Object)sa.getLast("sys4/val1"));
        List l = sa.getHistory("sys1/val1");
        Assert.assertNull((String)"sys1/val1 history", (Object)l);
        l = sa.getHistory("sys1/val2");
        Assert.assertEquals((String)"sys1/val2 history start", (long)2982009609899L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys2/val1");
        Assert.assertNull((String)"sys2/val1 history", (Object)l);
        l = sa.getHistory("sys3/val1");
        Assert.assertEquals((String)"sys3/val1 history start", (long)2982009609949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys3/val2");
        Assert.assertEquals((String)"sys3/val2 history start", (long)2982009609699L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        try {
            double av = sa.getAverage("sys1/val1");
            System.out.println("sys1/val1 average " + av);
            Assert.fail((String)"sys1/val1 aggregate should throw exception");
        }
        catch (NoSuchElementException av) {
            // empty catch block
        }
        try {
            double av = sa.getAverage("sys1/val2");
            System.out.println("sys1/val2 average " + av);
            Assert.fail((String)"sys1/val2 aggregate should throw exception");
        }
        catch (NoSuchElementException av) {
            // empty catch block
        }
        double s = 0.0;
        double mx = -1.7976931348623157E308;
        double mn = Double.MAX_VALUE;
        for (i = 9799; i < 10000; ++i) {
            s += Math.sin(i);
            if (mx < Math.sin(i)) {
                mx = Math.sin(i);
            }
            if (!(mn > Math.sin(i))) continue;
            mn = Math.sin(i);
        }
        Assert.assertEquals((String)"sys2/val1 average", (double)(s /= 201.0), (double)sa.getAverage("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 min", (double)mn, (double)sa.getMin("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 max", (double)mx, (double)sa.getMax("sys2/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        for (i = 9699; i < 10000; ++i) {
            s += Math.sin(i);
            if (mx < Math.sin(i)) {
                mx = Math.sin(i);
            }
            if (!(mn > Math.sin(i))) continue;
            mn = Math.sin(i);
        }
        Assert.assertEquals((String)"sys3/val1 average", (double)(s /= 301.0), (double)sa.getAverage("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 min", (double)mn, (double)sa.getMin("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 max", (double)mx, (double)sa.getMax("sys3/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        for (i = 9949; i < 10000; ++i) {
            s += Math.sin(i);
            if (mx < Math.sin(i)) {
                mx = Math.sin(i);
            }
            if (!(mn > Math.sin(i))) continue;
            mn = Math.sin(i);
        }
        Assert.assertEquals((String)"sys3/val2 average", (double)(s /= 51.0), (double)sa.getAverage("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 min", (double)mn, (double)sa.getMin("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 max", (double)mx, (double)sa.getMax("sys3/val2"), (double)1.0E-7);
    }

    @Test
    public void testAgregatorPattern() {
        int i;
        StatusAggregator sa = new StatusAggregator();
        sa.setAggregatePattern("sys[1-3]/val.", 50, 300);
        AgentInfo a1 = new AgentInfo("sys1", AgentInfo.AgentType.WORKER);
        AgentInfo a2 = new AgentInfo("sys2", AgentInfo.AgentType.WORKER);
        AgentInfo a3 = new AgentInfo("sys3", AgentInfo.AgentType.WORKER);
        AgentInfo a4 = new AgentInfo("sys4", AgentInfo.AgentType.WORKER);
        long offset = 2982009600000L;
        for (int i2 = 0; i2 < 10000; ++i2) {
            double val = Math.sin(i2);
            long ts = 2982009600000L + (long)i2;
            KeyValueDataList l1 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l1.addData("val1", (Serializable)Double.valueOf(val));
            l1.addData("val2", (Serializable)Double.valueOf(val));
            StatusSubsystemData s1 = new StatusSubsystemData((KeyValueData)l1);
            s1.setOriginAgentInfo(a1);
            KeyValueDataList l2 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l2.addData("val1", (Serializable)Double.valueOf(val));
            StatusSubsystemData s2 = new StatusSubsystemData((KeyValueData)l2);
            s2.setOriginAgentInfo(a2);
            KeyValueDataList l3 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l3.addData("val1", (Serializable)Double.valueOf(val));
            l3.addData("val2", (Serializable)Double.valueOf(val));
            StatusSubsystemData s3 = new StatusSubsystemData((KeyValueData)l3);
            s3.setOriginAgentInfo(a3);
            KeyValueDataList l4 = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)ts));
            l4.addData("val1", (Serializable)Double.valueOf(val));
            StatusSubsystemData s4 = new StatusSubsystemData((KeyValueData)l4);
            s4.setOriginAgentInfo(a4);
            sa.onStatusMessage((StatusMessage)s1);
            sa.onStatusMessage((StatusMessage)s2);
            sa.onStatusMessage((StatusMessage)s3);
            sa.onStatusMessage((StatusMessage)s4);
        }
        Assert.assertEquals((String)"sys1/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val1")), (double)0.001);
        Assert.assertEquals((String)"sys1/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys1/val2")), (double)0.001);
        Assert.assertEquals((String)"sys2/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys2/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val1 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val1")), (double)0.001);
        Assert.assertEquals((String)"sys3/val2 last", (double)Math.sin(9999.0), (double)((Double)sa.getLast("sys3/val2")), (double)0.001);
        Assert.assertNull((String)"sys4/val1 null", (Object)sa.getLast("sys4/val1"));
        List l = sa.getHistory("sys1/val1");
        Assert.assertEquals((String)"sys1/val1 history start", (long)2982009609949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys1/val2");
        Assert.assertEquals((String)"sys1/val2 history start", (long)2982009609949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys2/val1");
        Assert.assertEquals((String)"sys2/val1 history start", (long)2982009609949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys3/val1");
        Assert.assertEquals((String)"sys3/val1 history start", (long)2982009609949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        l = sa.getHistory("sys3/val2");
        Assert.assertEquals((String)"sys3/val2 history start", (long)2982009609949L, (long)((StatusAggregator.TimedValue)l.get(0)).gettStamp());
        double s = 0.0;
        double mx = -1.7976931348623157E308;
        double mn = Double.MAX_VALUE;
        for (i = 9699; i < 10000; ++i) {
            s += Math.sin(i);
            if (mx < Math.sin(i)) {
                mx = Math.sin(i);
            }
            if (!(mn > Math.sin(i))) continue;
            mn = Math.sin(i);
        }
        Assert.assertEquals((String)"sys2/val1 average", (double)(s /= 301.0), (double)sa.getAverage("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 min", (double)mn, (double)sa.getMin("sys2/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys2/val1 max", (double)mx, (double)sa.getMax("sys2/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        for (i = 9699; i < 10000; ++i) {
            s += Math.sin(i);
            if (mx < Math.sin(i)) {
                mx = Math.sin(i);
            }
            if (!(mn > Math.sin(i))) continue;
            mn = Math.sin(i);
        }
        Assert.assertEquals((String)"sys3/val1 average", (double)(s /= 301.0), (double)sa.getAverage("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 min", (double)mn, (double)sa.getMin("sys3/val1"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val1 max", (double)mx, (double)sa.getMax("sys3/val1"), (double)1.0E-7);
        s = 0.0;
        mx = -1.7976931348623157E308;
        mn = Double.MAX_VALUE;
        for (i = 9699; i < 10000; ++i) {
            s += Math.sin(i);
            if (mx < Math.sin(i)) {
                mx = Math.sin(i);
            }
            if (!(mn > Math.sin(i))) continue;
            mn = Math.sin(i);
        }
        Assert.assertEquals((String)"sys3/val2 average", (double)(s /= 301.0), (double)sa.getAverage("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 min", (double)mn, (double)sa.getMin("sys3/val2"), (double)1.0E-7);
        Assert.assertEquals((String)"sys3/val2 max", (double)mx, (double)sa.getMax("sys3/val2"), (double)1.0E-7);
    }
}

